/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueIoHandler;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class KqueueRegistrationTest {
    @BeforeEach
    public void setUp() {
        KQueue.ensureAvailability();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testFdReuse() throws Exception {
        Bootstrap bootstrap = new Bootstrap();
        MultiThreadIoEventLoopGroup group = new MultiThreadIoEventLoopGroup(1, KQueueIoHandler.newFactory());
        Promise promise = ImmediateEventExecutor.INSTANCE.newPromise();
        try {
            ((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)group)).channel(KQueueSocketChannel.class)).handler((ChannelHandler)new LoggingHandler());
            bootstrap.connect((SocketAddress)new InetSocketAddress(NetUtil.LOCALHOST, 4)).addListener((GenericFutureListener)((ChannelFutureListener)f1 -> {
                if (f1.cause() instanceof ConnectException) {
                    f1.channel().close();
                    bootstrap.connect((SocketAddress)new InetSocketAddress(NetUtil.LOCALHOST, 4)).addListener((GenericFutureListener)((ChannelFutureListener)f2 -> {
                        f2.channel().close();
                        promise.setSuccess((Object)f2.cause());
                    }));
                } else {
                    promise.setFailure((Throwable)new IllegalStateException());
                }
            }));
            Throwable cause = (Throwable)promise.sync().getNow();
            Assertions.assertInstanceOf(ConnectException.class, (Object)cause);
        }
        finally {
            group.shutdownGracefully();
        }
    }
}

