/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueDomainDatagramChannel;
import io.netty.channel.kqueue.KQueueDomainSocketChannel;
import io.netty.channel.kqueue.KQueueIoHandler;
import io.netty.channel.kqueue.KQueueServerDomainSocketChannel;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.socket.SocketProtocolFamily;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.tests.UnixTestUtils;
import io.netty.testsuite.transport.TestsuitePermutation;
import io.netty.testsuite.transport.socket.SocketTestPermutation;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadFactory;

class KQueueSocketTestPermutation
extends SocketTestPermutation {
    static final KQueueSocketTestPermutation INSTANCE = new KQueueSocketTestPermutation();
    static final EventLoopGroup KQUEUE_GROUP = new MultiThreadIoEventLoopGroup(4, (ThreadFactory)new DefaultThreadFactory("testsuite-KQueue-group", true), KQueueIoHandler.newFactory());

    KQueueSocketTestPermutation() {
    }

    public List<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>> socket() {
        List list = this.combo(this.serverSocket(), this.clientSocketWithFastOpen());
        list.remove(list.size() - 1);
        return list;
    }

    public List<TestsuitePermutation.BootstrapFactory<ServerBootstrap>> serverSocket() {
        ArrayList<TestsuitePermutation.BootstrapFactory<ServerBootstrap>> toReturn = new ArrayList<TestsuitePermutation.BootstrapFactory<ServerBootstrap>>();
        toReturn.add(new TestsuitePermutation.BootstrapFactory<ServerBootstrap>(){

            public ServerBootstrap newInstance() {
                return (ServerBootstrap)new ServerBootstrap().group(KQUEUE_GROUP).channel(KQueueServerSocketChannel.class);
            }
        });
        if (KQueue.isTcpFastOpenServerSideAvailable()) {
            toReturn.add(new TestsuitePermutation.BootstrapFactory<ServerBootstrap>(){

                public ServerBootstrap newInstance() {
                    ServerBootstrap serverBootstrap = (ServerBootstrap)new ServerBootstrap().group(KQUEUE_GROUP).channel(KQueueServerSocketChannel.class);
                    serverBootstrap.option(ChannelOption.TCP_FASTOPEN, (Object)1);
                    return serverBootstrap;
                }
            });
        }
        toReturn.add(new TestsuitePermutation.BootstrapFactory<ServerBootstrap>(){

            public ServerBootstrap newInstance() {
                return (ServerBootstrap)new ServerBootstrap().group(KQueueSocketTestPermutation.this.NIO_GROUP).channel(NioServerSocketChannel.class);
            }
        });
        return toReturn;
    }

    public List<TestsuitePermutation.BootstrapFactory<Bootstrap>> clientSocket() {
        ArrayList<TestsuitePermutation.BootstrapFactory<Bootstrap>> toReturn = new ArrayList<TestsuitePermutation.BootstrapFactory<Bootstrap>>();
        toReturn.add(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(KQUEUE_GROUP)).channel(KQueueSocketChannel.class);
            }
        });
        toReturn.add(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(KQueueSocketTestPermutation.this.NIO_GROUP)).channel(NioSocketChannel.class);
            }
        });
        return toReturn;
    }

    public List<TestsuitePermutation.BootstrapFactory<Bootstrap>> clientSocketWithFastOpen() {
        List<TestsuitePermutation.BootstrapFactory<Bootstrap>> factories = this.clientSocket();
        if (KQueue.isTcpFastOpenClientSideAvailable()) {
            int insertIndex = factories.size() - 1;
            factories.add(insertIndex, new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

                public Bootstrap newInstance() {
                    return (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(KQUEUE_GROUP)).channel(KQueueSocketChannel.class)).option(ChannelOption.TCP_FASTOPEN_CONNECT, (Object)true);
                }
            });
        }
        return factories;
    }

    public List<TestsuitePermutation.BootstrapComboFactory<Bootstrap, Bootstrap>> datagram(final SocketProtocolFamily family) {
        List<TestsuitePermutation.BootstrapFactory> bfs = Arrays.asList(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(KQueueSocketTestPermutation.this.NIO_GROUP)).channelFactory((ChannelFactory)new ChannelFactory<Channel>(){

                    public Channel newChannel() {
                        return new NioDatagramChannel(family);
                    }

                    public String toString() {
                        return NioDatagramChannel.class.getSimpleName() + ".class";
                    }
                });
            }
        }, new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(KQUEUE_GROUP)).channelFactory((ChannelFactory)new ChannelFactory<Channel>(){

                    public Channel newChannel() {
                        return new KQueueDatagramChannel(family);
                    }

                    public String toString() {
                        return KQueueDatagramChannel.class.getSimpleName() + ".class";
                    }
                });
            }
        });
        return this.combo(bfs, bfs);
    }

    public List<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>> domainSocket() {
        return this.combo(this.serverDomainSocket(), this.clientDomainSocket());
    }

    public List<TestsuitePermutation.BootstrapFactory<ServerBootstrap>> serverDomainSocket() {
        return Collections.singletonList(new TestsuitePermutation.BootstrapFactory<ServerBootstrap>(){

            public ServerBootstrap newInstance() {
                return (ServerBootstrap)new ServerBootstrap().group(KQUEUE_GROUP).channel(KQueueServerDomainSocketChannel.class);
            }
        });
    }

    public List<TestsuitePermutation.BootstrapFactory<Bootstrap>> clientDomainSocket() {
        return Collections.singletonList(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(KQUEUE_GROUP)).channel(KQueueDomainSocketChannel.class);
            }
        });
    }

    public List<TestsuitePermutation.BootstrapFactory<Bootstrap>> datagramSocket() {
        return Collections.singletonList(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(KQUEUE_GROUP)).channel(KQueueDatagramChannel.class);
            }
        });
    }

    public List<TestsuitePermutation.BootstrapComboFactory<Bootstrap, Bootstrap>> domainDatagram() {
        return this.combo(this.domainDatagramSocket(), this.domainDatagramSocket());
    }

    public List<TestsuitePermutation.BootstrapFactory<Bootstrap>> domainDatagramSocket() {
        return Collections.singletonList(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(KQUEUE_GROUP)).channel(KQueueDomainDatagramChannel.class);
            }
        });
    }

    public static DomainSocketAddress newSocketAddress() {
        return UnixTestUtils.newDomainSocketAddress();
    }
}

