/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.kqueue.BsdSocket;
import io.netty.channel.kqueue.KQueueSocketTestPermutation;
import io.netty.channel.unix.Buffer;
import io.netty.testsuite.transport.TestsuitePermutation;
import io.netty.testsuite.transport.socket.AbstractSocketShutdownOutputByPeerTest;
import io.netty.util.internal.CleanableDirectBuffer;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.List;

public class KQueueDomainSocketShutdownOutputByPeerTest
extends AbstractSocketShutdownOutputByPeerTest<BsdSocket> {
    protected List<TestsuitePermutation.BootstrapFactory<ServerBootstrap>> newFactories() {
        return KQueueSocketTestPermutation.INSTANCE.serverDomainSocket();
    }

    protected SocketAddress newSocketAddress() {
        return KQueueSocketTestPermutation.newSocketAddress();
    }

    protected void shutdownOutput(BsdSocket s) throws IOException {
        s.shutdown(false, true);
    }

    protected void connect(BsdSocket s, SocketAddress address) throws IOException {
        s.connect(address);
    }

    protected void close(BsdSocket s) throws IOException {
        s.close();
    }

    protected void write(BsdSocket s, int data) throws IOException {
        CleanableDirectBuffer cleanableDirectBuffer = Buffer.allocateDirectBufferWithNativeOrder((int)4);
        ByteBuffer buf = cleanableDirectBuffer.buffer();
        buf.putInt(data);
        buf.flip();
        s.write(buf, buf.position(), buf.limit());
        cleanableDirectBuffer.clean();
    }

    protected BsdSocket newSocket() {
        return BsdSocket.newSocketDomain();
    }
}

