/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.unix.Buffer;
import io.netty.channel.unix.IntegerUnixChannelOption;
import io.netty.channel.unix.RawUnixChannelOption;
import io.netty.util.internal.CleanableDirectBuffer;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class KQueueChannelConfigTest {
    @BeforeEach
    public void before() {
        KQueue.ensureAvailability();
    }

    @Test
    public void testOptionGetThrowsChannelException() throws Exception {
        KQueueSocketChannel channel = new KQueueSocketChannel();
        channel.config().getSoLinger();
        channel.fd().close();
        try {
            channel.config().getSoLinger();
            Assertions.fail();
        }
        catch (ChannelException channelException) {
            // empty catch block
        }
    }

    @Test
    public void testOptionSetThrowsChannelException() throws Exception {
        KQueueSocketChannel channel = new KQueueSocketChannel();
        channel.config().setKeepAlive(true);
        channel.fd().close();
        try {
            channel.config().setKeepAlive(true);
            Assertions.fail();
        }
        catch (ChannelException channelException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSoLingerNoAssertError() throws Exception {
        KQueueEventLoopGroup group = new KQueueEventLoopGroup(1);
        try {
            Bootstrap bootstrap = new Bootstrap();
            KQueueSocketChannel ch = (KQueueSocketChannel)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)group)).channel(KQueueSocketChannel.class)).option(ChannelOption.SO_LINGER, (Object)10)).handler((ChannelHandler)new ChannelInboundHandlerAdapter())).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            ch.close().syncUninterruptibly();
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Test
    public void testIntegerOption() throws Exception {
        KQueueSocketChannel channel = new KQueueSocketChannel();
        IntegerUnixChannelOption opt = new IntegerUnixChannelOption("INT_OPT", 65535, 4);
        Integer zero = 0;
        Assertions.assertEquals((Integer)zero, (Integer)((Integer)channel.config().getOption((ChannelOption)opt)));
        channel.config().setOption((ChannelOption)opt, (Object)1);
        Assertions.assertNotEquals((Integer)zero, (Integer)((Integer)channel.config().getOption((ChannelOption)opt)));
        channel.fd().close();
    }

    @Test
    public void testRawOption() throws Exception {
        KQueueSocketChannel channel = new KQueueSocketChannel();
        RawUnixChannelOption opt = new RawUnixChannelOption("RAW_OPT", 65535, 4, 4);
        CleanableDirectBuffer disabledCleanable = Buffer.allocateDirectBufferWithNativeOrder((int)4);
        ByteBuffer disabled = disabledCleanable.buffer();
        disabled.putInt(0).flip();
        Assertions.assertEquals((Object)disabled, (Object)channel.config().getOption((ChannelOption)opt));
        CleanableDirectBuffer enabledCleanable = Buffer.allocateDirectBufferWithNativeOrder((int)4);
        ByteBuffer enabled = enabledCleanable.buffer();
        enabled.putInt(1).flip();
        channel.config().setOption((ChannelOption)opt, (Object)enabled);
        Assertions.assertNotEquals((Object)disabled, (Object)channel.config().getOption((ChannelOption)opt));
        channel.fd().close();
        disabledCleanable.clean();
        enabledCleanable.clean();
    }
}

