/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.timeout;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class IdleStateHandlerTest {
    @Test
    public void testReaderIdle() throws Exception {
        IdleStateHandler idleStateHandler = new IdleStateHandler(false, 1L, 0L, 0L, TimeUnit.SECONDS);
        IdleStateHandlerTest.anyIdle(idleStateHandler, IdleStateEvent.FIRST_READER_IDLE_STATE_EVENT, IdleStateEvent.READER_IDLE_STATE_EVENT, IdleStateEvent.READER_IDLE_STATE_EVENT);
    }

    @Test
    public void testWriterIdle() throws Exception {
        IdleStateHandler idleStateHandler = new IdleStateHandler(false, 0L, 1L, 0L, TimeUnit.SECONDS);
        IdleStateHandlerTest.anyIdle(idleStateHandler, IdleStateEvent.FIRST_WRITER_IDLE_STATE_EVENT, IdleStateEvent.WRITER_IDLE_STATE_EVENT, IdleStateEvent.WRITER_IDLE_STATE_EVENT);
    }

    @Test
    public void testAllIdle() throws Exception {
        IdleStateHandler idleStateHandler = new IdleStateHandler(false, 0L, 0L, 1L, TimeUnit.SECONDS);
        IdleStateHandlerTest.anyIdle(idleStateHandler, IdleStateEvent.FIRST_ALL_IDLE_STATE_EVENT, IdleStateEvent.ALL_IDLE_STATE_EVENT, IdleStateEvent.ALL_IDLE_STATE_EVENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void anyIdle(IdleStateHandler idleStateHandler, Object ... expected) throws Exception {
        Assertions.assertThat((int)expected.length).isGreaterThanOrEqualTo(1);
        final ArrayList events = new ArrayList();
        ChannelInboundHandlerAdapter handler = new ChannelInboundHandlerAdapter(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                events.add(evt);
            }
        };
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{idleStateHandler, handler});
        channel.freezeTime();
        try {
            int i;
            for (i = 0; i < expected.length; ++i) {
                channel.advanceTimeBy(1L, TimeUnit.SECONDS);
                channel.runPendingTasks();
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)expected.length, (int)events.size());
            for (i = 0; i < expected.length; ++i) {
                Object evt = events.get(i);
                org.junit.jupiter.api.Assertions.assertSame((Object)expected[i], evt, (String)("Element " + i + " is not matching"));
            }
        }
        finally {
            channel.finishAndReleaseAll();
        }
    }

    @Test
    public void testResetReader() throws Exception {
        final IdleStateHandler idleStateHandler = new IdleStateHandler(false, 1L, 0L, 0L, TimeUnit.SECONDS);
        Action action = new Action(){

            @Override
            public void run(EmbeddedChannel channel) throws Exception {
                idleStateHandler.resetReadTimeout();
            }
        };
        IdleStateHandlerTest.anyNotIdle(idleStateHandler, action, IdleStateEvent.FIRST_READER_IDLE_STATE_EVENT);
    }

    @Test
    public void testResetWriter() throws Exception {
        final IdleStateHandler idleStateHandler = new IdleStateHandler(false, 0L, 1L, 0L, TimeUnit.SECONDS);
        Action action = new Action(){

            @Override
            public void run(EmbeddedChannel channel) throws Exception {
                idleStateHandler.resetWriteTimeout();
            }
        };
        IdleStateHandlerTest.anyNotIdle(idleStateHandler, action, IdleStateEvent.FIRST_WRITER_IDLE_STATE_EVENT);
    }

    @Test
    public void testReaderNotIdle() throws Exception {
        IdleStateHandler idleStateHandler = new IdleStateHandler(false, 1L, 0L, 0L, TimeUnit.SECONDS);
        Action action = new Action(){

            @Override
            public void run(EmbeddedChannel channel) throws Exception {
                channel.writeInbound(new Object[]{"Hello, World!"});
            }
        };
        IdleStateHandlerTest.anyNotIdle(idleStateHandler, action, IdleStateEvent.FIRST_READER_IDLE_STATE_EVENT);
    }

    @Test
    public void testWriterNotIdle() throws Exception {
        IdleStateHandler idleStateHandler = new IdleStateHandler(false, 0L, 1L, 0L, TimeUnit.SECONDS);
        Action action = new Action(){

            @Override
            public void run(EmbeddedChannel channel) throws Exception {
                channel.writeAndFlush((Object)"Hello, World!");
            }
        };
        IdleStateHandlerTest.anyNotIdle(idleStateHandler, action, IdleStateEvent.FIRST_WRITER_IDLE_STATE_EVENT);
    }

    @Test
    public void testAllNotIdle() throws Exception {
        IdleStateHandler idleStateHandler = new IdleStateHandler(false, 0L, 0L, 1L, TimeUnit.SECONDS);
        Action reader = new Action(){

            @Override
            public void run(EmbeddedChannel channel) throws Exception {
                channel.writeInbound(new Object[]{"Hello, World!"});
            }
        };
        IdleStateHandlerTest.anyNotIdle(idleStateHandler, reader, IdleStateEvent.FIRST_ALL_IDLE_STATE_EVENT);
        idleStateHandler = new IdleStateHandler(false, 0L, 0L, 1L, TimeUnit.SECONDS);
        Action writer = new Action(){

            @Override
            public void run(EmbeddedChannel channel) throws Exception {
                channel.writeAndFlush((Object)"Hello, World!");
            }
        };
        IdleStateHandlerTest.anyNotIdle(idleStateHandler, writer, IdleStateEvent.FIRST_ALL_IDLE_STATE_EVENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void anyNotIdle(IdleStateHandler idleStateHandler, Action action, Object expected) throws Exception {
        final ArrayList events = new ArrayList();
        ChannelInboundHandlerAdapter handler = new ChannelInboundHandlerAdapter(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                events.add(evt);
            }
        };
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{idleStateHandler, handler});
        channel.freezeTime();
        try {
            long delayInNanos = TimeUnit.SECONDS.toNanos(1L);
            channel.advanceTimeBy(delayInNanos / 2L + 1L, TimeUnit.NANOSECONDS);
            action.run(channel);
            channel.advanceTimeBy(delayInNanos / 2L, TimeUnit.NANOSECONDS);
            channel.runPendingTasks();
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)events.size());
            channel.advanceTimeBy(delayInNanos, TimeUnit.NANOSECONDS);
            channel.runPendingTasks();
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)events.size());
            org.junit.jupiter.api.Assertions.assertSame((Object)expected, events.get(0));
        }
        finally {
            channel.finishAndReleaseAll();
        }
    }

    @Test
    public void testObserveWriterIdle() throws Exception {
        IdleStateHandlerTest.observeOutputIdle(true);
    }

    @Test
    public void testObserveAllIdle() throws Exception {
        IdleStateHandlerTest.observeOutputIdle(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void observeOutputIdle(boolean writer) throws Exception {
        IdleStateEvent expected;
        long writerIdleTime = 0L;
        long allIdleTime = 0L;
        if (writer) {
            writerIdleTime = 5L;
            expected = IdleStateEvent.FIRST_WRITER_IDLE_STATE_EVENT;
        } else {
            allIdleTime = 5L;
            expected = IdleStateEvent.FIRST_ALL_IDLE_STATE_EVENT;
        }
        IdleStateHandler idleStateHandler = new IdleStateHandler(true, 0L, writerIdleTime, allIdleTime, TimeUnit.SECONDS);
        final ArrayList events = new ArrayList();
        ChannelInboundHandlerAdapter handler = new ChannelInboundHandlerAdapter(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                events.add(evt);
            }
        };
        ObservableChannel channel = new ObservableChannel(new ChannelHandler[]{idleStateHandler, handler});
        channel.freezeTime();
        try {
            channel.writeAndFlush(Unpooled.wrappedBuffer((byte[])new byte[]{1}));
            channel.writeAndFlush(Unpooled.wrappedBuffer((byte[])new byte[]{2}));
            channel.writeAndFlush(Unpooled.wrappedBuffer((byte[])new byte[]{3}));
            channel.writeAndFlush(Unpooled.wrappedBuffer((byte[])new byte[5120]));
            channel.advanceTimeBy(5L, TimeUnit.SECONDS);
            channel.runPendingTasks();
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)events.size());
            org.junit.jupiter.api.Assertions.assertSame((Object)expected, events.get(0));
            events.clear();
            channel.advanceTimeBy(4L, TimeUnit.SECONDS);
            channel.runPendingTasks();
            IdleStateHandlerTest.assertNotNullAndRelease(channel.consume());
            channel.advanceTimeBy(2L, TimeUnit.SECONDS);
            channel.runPendingTasks();
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)events.size());
            channel.advanceTimeBy(2L, TimeUnit.SECONDS);
            channel.runPendingTasks();
            IdleStateHandlerTest.assertNotNullAndRelease(channel.consume());
            channel.advanceTimeBy(4L, TimeUnit.SECONDS);
            channel.runPendingTasks();
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)events.size());
            channel.advanceTimeBy(5L, TimeUnit.SECONDS);
            channel.runPendingTasks();
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)events.size());
            events.clear();
            channel.advanceTimeBy(2L, TimeUnit.SECONDS);
            channel.runPendingTasks();
            IdleStateHandlerTest.assertNotNullAndRelease(channel.consume());
            channel.advanceTimeBy(1L, TimeUnit.SECONDS);
            channel.runPendingTasks();
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)events.size());
            channel.advanceTimeBy(2L, TimeUnit.SECONDS);
            channel.runPendingTasks();
            IdleStateHandlerTest.assertNotNullAndRelease(channel.consumePart(1024));
            channel.advanceTimeBy(2L, TimeUnit.SECONDS);
            channel.runPendingTasks();
            IdleStateHandlerTest.assertNotNullAndRelease(channel.consumePart(1024));
            channel.advanceTimeBy(1L, TimeUnit.SECONDS);
            channel.runPendingTasks();
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)events.size());
            events.clear();
            channel.advanceTimeBy(2L, TimeUnit.SECONDS);
            channel.runPendingTasks();
            IdleStateHandlerTest.assertNotNullAndRelease(channel.consumePart(1024));
            channel.advanceTimeBy(2L, TimeUnit.SECONDS);
            channel.runPendingTasks();
            IdleStateHandlerTest.assertNotNullAndRelease(channel.consumePart(1024));
            channel.advanceTimeBy(1L, TimeUnit.SECONDS);
            channel.runPendingTasks();
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)events.size());
            channel.advanceTimeBy(2L, TimeUnit.SECONDS);
            channel.runPendingTasks();
            IdleStateHandlerTest.assertNotNullAndRelease(channel.consumePart(1024));
            channel.advanceTimeBy(3L, TimeUnit.SECONDS);
            channel.runPendingTasks();
            org.junit.jupiter.api.Assertions.assertNull((Object)channel.consume());
            channel.advanceTimeBy(2L, TimeUnit.SECONDS);
            channel.runPendingTasks();
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)events.size());
        }
        finally {
            channel.finishAndReleaseAll();
        }
    }

    private static void assertNotNullAndRelease(Object msg) {
        org.junit.jupiter.api.Assertions.assertNotNull((Object)msg);
        ReferenceCountUtil.release((Object)msg);
    }

    private static class ObservableChannel
    extends EmbeddedChannel {
        ObservableChannel(ChannelHandler ... handlers) {
            super(handlers);
        }

        protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        }

        private Object consume() {
            Object msg;
            ChannelOutboundBuffer buf = this.unsafe().outboundBuffer();
            if (buf != null && (msg = buf.current()) != null) {
                ReferenceCountUtil.retain((Object)msg);
                buf.remove();
                return msg;
            }
            return null;
        }

        private Object consumePart(int byteCount) {
            Object msg;
            ChannelOutboundBuffer buf = this.unsafe().outboundBuffer();
            if (buf != null && (msg = buf.current()) != null) {
                ReferenceCountUtil.retain((Object)msg);
                buf.removeBytes((long)byteCount);
                return msg;
            }
            return null;
        }
    }

    private static interface Action {
        public void run(EmbeddedChannel var1) throws Exception;
    }
}

