/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl.util;

import io.netty.handler.ssl.util.KeytoolSelfSignedCertGenerator;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class KeytoolSelfSignedCertGeneratorTest {
    KeytoolSelfSignedCertGeneratorTest() {
    }

    @BeforeAll
    static void checkAvailability() {
        Assumptions.assumeTrue((boolean)KeytoolSelfSignedCertGenerator.isAvailable());
    }

    @Test
    public void test() throws Exception {
        X509Certificate cert;
        SelfSignedCertificate.Builder builder = SelfSignedCertificate.builder().fqdn("example.com").algorithm("RSA").bits(2048);
        Assertions.assertTrue((boolean)builder.generateKeytool());
        Assertions.assertEquals((Object)"RSA", (Object)builder.privateKey.getAlgorithm());
        try (InputStream certStream = Files.newInputStream(Paths.get(builder.paths[0], new String[0]), new OpenOption[0]);){
            cert = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(certStream);
        }
        cert.checkValidity();
        Assertions.assertEquals((Object)"CN=example.com", (Object)cert.getSubjectX500Principal().getName());
    }
}

