/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl.util;

import io.netty.handler.ssl.Java8SslTestUtils;
import io.netty.handler.ssl.util.FingerprintTrustManagerFactory;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class FingerprintTrustManagerFactoryTest {
    private static final String FIRST_CERT_SHA1_FINGERPRINT = "18:C7:C2:76:1F:DF:72:3B:2A:A7:BB:2C:B0:30:D4:C0:C0:72:AD:84";
    private static final String FIRST_CERT_SHA256_FINGERPRINT = "1C:53:0E:6B:FF:93:F0:DE:C2:E6:E7:9D:10:53:58:FF:DD:8E:68:CD:82:D9:C9:36:9B:43:EE:B3:DC:13:68:FB";
    private static final X509Certificate[] FIRST_CHAIN;
    private static final X509Certificate[] SECOND_CHAIN;

    @Test
    public void testFingerprintWithInvalidLength() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                FingerprintTrustManagerFactory.builder((String)"SHA-256").fingerprints(new CharSequence[]{"00:00:00"}).build();
            }
        });
    }

    @Test
    public void testFingerprintWithUnexpectedCharacters() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                FingerprintTrustManagerFactory.builder((String)"SHA-256").fingerprints(new CharSequence[]{"00:00:00\n"}).build();
            }
        });
    }

    @Test
    public void testWithNoFingerprints() {
        Assertions.assertThrows(IllegalStateException.class, (Executable)new Executable(){

            public void execute() {
                FingerprintTrustManagerFactory.builder((String)"SHA-256").build();
            }
        });
    }

    @Test
    public void testWithNullFingerprint() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                FingerprintTrustManagerFactory.builder((String)"SHA-256").fingerprints(new CharSequence[]{FingerprintTrustManagerFactoryTest.FIRST_CERT_SHA256_FINGERPRINT, null}).build();
            }
        });
    }

    @Test
    public void testValidSHA1Fingerprint() throws Exception {
        FingerprintTrustManagerFactory factory = new FingerprintTrustManagerFactory(new String[]{FIRST_CERT_SHA1_FINGERPRINT});
        Assertions.assertTrue((factory.engineGetTrustManagers().length > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)(factory.engineGetTrustManagers()[0] instanceof X509TrustManager));
        X509TrustManager tm = (X509TrustManager)factory.engineGetTrustManagers()[0];
        tm.checkClientTrusted(FIRST_CHAIN, "test");
    }

    @Test
    public void testTrustedCertificateWithSHA256Fingerprint() throws Exception {
        FingerprintTrustManagerFactory factory = FingerprintTrustManagerFactory.builder((String)"SHA-256").fingerprints(new CharSequence[]{FIRST_CERT_SHA256_FINGERPRINT}).build();
        X509Certificate[] keyCertChain = Java8SslTestUtils.loadCertCollection("test.crt");
        Assertions.assertNotNull((Object)keyCertChain);
        Assertions.assertTrue((factory.engineGetTrustManagers().length > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)(factory.engineGetTrustManagers()[0] instanceof X509TrustManager));
        X509TrustManager tm = (X509TrustManager)factory.engineGetTrustManagers()[0];
        tm.checkClientTrusted(keyCertChain, "test");
    }

    @Test
    public void testUntrustedCertificateWithSHA256Fingerprint() throws Exception {
        FingerprintTrustManagerFactory factory = FingerprintTrustManagerFactory.builder((String)"SHA-256").fingerprints(new CharSequence[]{FIRST_CERT_SHA256_FINGERPRINT}).build();
        Assertions.assertTrue((factory.engineGetTrustManagers().length > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)(factory.engineGetTrustManagers()[0] instanceof X509TrustManager));
        final X509TrustManager tm = (X509TrustManager)factory.engineGetTrustManagers()[0];
        Assertions.assertThrows(CertificateException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                tm.checkClientTrusted(SECOND_CHAIN, "test");
            }
        });
    }

    static {
        try {
            FIRST_CHAIN = Java8SslTestUtils.loadCertCollection("test.crt");
            SECOND_CHAIN = Java8SslTestUtils.loadCertCollection("test2.crt");
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

