/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl.util;

import io.netty.handler.ssl.util.BouncyCastleUtil;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated(value="Provider value stored in the BouncyCastlePemReader#bcProvider field is also used by other tests")
public class BouncyCastleUtilTest {
    @Test
    public void testBouncyCastleProviderLoaded() {
        Assertions.assertTrue((boolean)BouncyCastleUtil.isBcProvAvailable());
        Assertions.assertTrue((boolean)BouncyCastleUtil.isBcPkixAvailable());
        Assertions.assertTrue((boolean)BouncyCastleUtil.isBcTlsAvailable());
        Provider bcProvider = BouncyCastleUtil.getBcProviderJce();
        Assertions.assertNotNull((Object)bcProvider);
        Assertions.assertNotNull((Object)BouncyCastleUtil.getBcProviderJsse());
        BouncyCastleUtil.reset();
        BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();
        Security.addProvider((Provider)bouncyCastleProvider);
        Assertions.assertTrue((boolean)BouncyCastleUtil.isBcProvAvailable());
        bcProvider = BouncyCastleUtil.getBcProviderJce();
        Assertions.assertSame((Object)bouncyCastleProvider, (Object)bcProvider);
        Security.removeProvider(bouncyCastleProvider.getName());
        BouncyCastleUtil.reset();
    }

    @Test
    public void testBouncyCastleFipsProviderLoaded() {
        Assertions.assertTrue((boolean)BouncyCastleUtil.isBcProvAvailable());
        Provider bcProvider = BouncyCastleUtil.getBcProviderJce();
        Assertions.assertInstanceOf(BouncyCastleProvider.class, (Object)bcProvider);
        BouncyCastleUtil.reset();
        Provider fakeBouncyCastleFipsProvider = new Provider("BCFIPS", 1.000205, "BouncyCastle Security Provider (FIPS edition) v1.0.2.5"){};
        Security.addProvider(fakeBouncyCastleFipsProvider);
        Assertions.assertTrue((boolean)BouncyCastleUtil.isBcProvAvailable());
        bcProvider = BouncyCastleUtil.getBcProviderJce();
        Assertions.assertSame((Object)fakeBouncyCastleFipsProvider, (Object)bcProvider);
        Security.removeProvider(fakeBouncyCastleFipsProvider.getName());
        BouncyCastleUtil.reset();
    }
}

