/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.ssl.SslHandlerCoalescingBufferQueue;
import java.nio.ByteBuffer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class SslHandlerCoalescingBufferQueueTest {
    static final Supplier<ByteBuf> BYTEBUF_SUPPLIER = new Supplier<ByteBuf>(){

        @Override
        public ByteBuf get() {
            ByteBuf buf = Unpooled.directBuffer((int)128);
            buf.writeLong(1L);
            buf.writeLong(2L);
            return buf;
        }
    };
    static final Function<ByteBuf, ByteBuf> NO_WRAPPER = new Function<ByteBuf, ByteBuf>(){

        @Override
        public ByteBuf apply(ByteBuf byteBuf) {
            return byteBuf;
        }
    };
    static final Function<ByteBuf, ByteBuf> DUPLICATE_WRAPPER = new Function<ByteBuf, ByteBuf>(){

        @Override
        public ByteBuf apply(ByteBuf byteBuf) {
            return byteBuf.duplicate();
        }
    };
    static final Function<ByteBuf, ByteBuf> SLICE_WRAPPER = new Function<ByteBuf, ByteBuf>(){

        @Override
        public ByteBuf apply(ByteBuf byteBuf) {
            return byteBuf.slice();
        }
    };

    static ByteBuffer createNioBuffer() {
        ByteBuffer nioBuffer = ByteBuffer.allocateDirect(128);
        nioBuffer.putLong(1L);
        nioBuffer.putLong(2L);
        nioBuffer.position(nioBuffer.limit());
        nioBuffer.flip();
        return nioBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=CumulationTestScenario.class)
    public void testCumulation(CumulationTestScenario testScenario) {
        EmbeddedChannel channel = new EmbeddedChannel();
        SslHandlerCoalescingBufferQueue queue = new SslHandlerCoalescingBufferQueue((Channel)channel, 16, false){

            protected int wrapDataSize() {
                return 128;
            }
        };
        ByteBuf original = testScenario.bufferSupplier.get();
        original.writerIndex(8);
        ByteBuf first = testScenario.bufferWrapper.apply(original);
        first.retain();
        queue.add(first);
        ByteBuf second = Unpooled.copyLong((long)3L);
        queue.add(second);
        ChannelPromise promise = channel.newPromise();
        Assertions.assertFalse((boolean)queue.isEmpty());
        ByteBuf buffer = queue.remove((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, 128, promise);
        try {
            Assertions.assertEquals((int)16, (int)buffer.readableBytes());
            Assertions.assertEquals((long)1L, (long)buffer.readLong());
            Assertions.assertEquals((long)3L, (long)buffer.readLong());
        }
        finally {
            buffer.release();
        }
        Assertions.assertTrue((boolean)queue.isEmpty());
        Assertions.assertEquals((int)8, (int)original.writerIndex());
        original.writerIndex(original.capacity());
        Assertions.assertEquals((long)2L, (long)original.getLong(8));
        first.release();
        Assertions.assertEquals((int)0, (int)first.refCnt());
        Assertions.assertEquals((int)0, (int)second.refCnt());
    }

    static enum CumulationTestScenario {
        BASIC_NIO_BUFFER(new Supplier(){

            public ByteBuf get() {
                return Unpooled.wrappedBuffer((ByteBuffer)SslHandlerCoalescingBufferQueueTest.createNioBuffer());
            }
        }, NO_WRAPPER),
        READ_ONLY_AND_DUPLICATE_NIO_BUFFER(new Supplier(){

            public ByteBuf get() {
                return Unpooled.wrappedBuffer((ByteBuffer)SslHandlerCoalescingBufferQueueTest.createNioBuffer().asReadOnlyBuffer());
            }
        }, DUPLICATE_WRAPPER),
        BASIC_DIRECT_BUFFER(BYTEBUF_SUPPLIER, NO_WRAPPER),
        DUPLICATE_DIRECT_BUFFER(BYTEBUF_SUPPLIER, DUPLICATE_WRAPPER),
        SLICED_DIRECT_BUFFER(BYTEBUF_SUPPLIER, SLICE_WRAPPER);

        final Supplier<ByteBuf> bufferSupplier;
        final Function<ByteBuf, ByteBuf> bufferWrapper;

        private CumulationTestScenario(Supplier<ByteBuf> bufferSupplier, Function<ByteBuf, ByteBuf> bufferWrapper) {
            this.bufferSupplier = bufferSupplier;
            this.bufferWrapper = bufferWrapper;
        }
    }
}

