/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.SslContext;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ResourcesUtil;
import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public abstract class SslContextTest {
    @Test
    public void testUnencryptedEmptyPassword() throws Exception {
        Assertions.assertThrows(IOException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                SslContext.toPrivateKey((File)ResourcesUtil.getFile(this.getClass(), (String)"test2_unencrypted.pem"), (String)"");
            }
        });
    }

    @Test
    public void testUnEncryptedNullPassword() throws Exception {
        PrivateKey key = SslContext.toPrivateKey((File)ResourcesUtil.getFile(this.getClass(), (String)"test2_unencrypted.pem"), null);
        Assertions.assertNotNull((Object)key);
    }

    @Test
    public void testEncryptedEmptyPassword() throws Exception {
        PrivateKey key = SslContext.toPrivateKey((File)ResourcesUtil.getFile(this.getClass(), (String)"test_encrypted_empty_pass.pem"), (String)"");
        Assertions.assertNotNull((Object)key);
    }

    @Test
    public void testEncryptedNullPassword() throws Exception {
        Assertions.assertThrows(InvalidKeySpecException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                SslContext.toPrivateKey((File)ResourcesUtil.getFile(this.getClass(), (String)"test_encrypted_empty_pass.pem"), null);
            }
        });
    }

    @Test
    public void testSslContextWithEncryptedPrivateKey() throws SSLException {
        File keyFile = ResourcesUtil.getFile(this.getClass(), (String)"test_encrypted.pem");
        File crtFile = ResourcesUtil.getFile(this.getClass(), (String)"test.crt");
        ReferenceCountUtil.release((Object)this.newSslContext(crtFile, keyFile, "12345"));
    }

    @Test
    public void testSslContextWithEncryptedPrivateKey2() throws SSLException {
        File keyFile = ResourcesUtil.getFile(this.getClass(), (String)"test2_encrypted.pem");
        File crtFile = ResourcesUtil.getFile(this.getClass(), (String)"test2.crt");
        ReferenceCountUtil.release((Object)this.newSslContext(crtFile, keyFile, "12345"));
    }

    @Test
    public void testSslContextWithUnencryptedPrivateKey() throws SSLException {
        File keyFile = ResourcesUtil.getFile(this.getClass(), (String)"test_unencrypted.pem");
        File crtFile = ResourcesUtil.getFile(this.getClass(), (String)"test.crt");
        ReferenceCountUtil.release((Object)this.newSslContext(crtFile, keyFile, null));
    }

    @Test
    public void testSslContextWithUnencryptedPrivateKeyEmptyPass() throws SSLException {
        final File keyFile = ResourcesUtil.getFile(this.getClass(), (String)"test_unencrypted.pem");
        final File crtFile = ResourcesUtil.getFile(this.getClass(), (String)"test.crt");
        Assertions.assertThrows(SSLException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                SslContextTest.this.newSslContext(crtFile, keyFile, "");
            }
        });
    }

    @Test
    public void testSupportedCiphers() throws KeyManagementException, NoSuchAlgorithmException, SSLException {
        SSLContext jdkSslContext = SSLContext.getInstance("TLS");
        jdkSslContext.init(null, null, null);
        SSLEngine sslEngine = jdkSslContext.createSSLEngine();
        String unsupportedCipher = "TLS_DH_anon_WITH_DES_CBC_SHA";
        IllegalArgumentException exception = null;
        try {
            sslEngine.setEnabledCipherSuites(new String[]{unsupportedCipher});
        }
        catch (IllegalArgumentException e) {
            exception = e;
        }
        Assumptions.assumeTrue((exception != null ? 1 : 0) != 0);
        File keyFile = ResourcesUtil.getFile(this.getClass(), (String)"test_unencrypted.pem");
        File crtFile = ResourcesUtil.getFile(this.getClass(), (String)"test.crt");
        SslContext sslContext = this.newSslContext(crtFile, keyFile, null);
        Assertions.assertFalse((boolean)sslContext.cipherSuites().contains(unsupportedCipher));
        ReferenceCountUtil.release((Object)sslContext);
    }

    @Test
    public void testUnsupportedParams() throws CertificateException {
        Assertions.assertThrows(CertificateException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                SslContext.toX509Certificates((File)new File(this.getClass().getResource("ec_params_unsupported.pem").getFile()));
            }
        });
    }

    protected abstract SslContext newSslContext(File var1, File var2, String var3) throws SSLException;

    @Test
    public void testPkcs1UnencryptedRsa() throws Exception {
        PrivateKey key = SslContext.toPrivateKey((File)new File(this.getClass().getResource("rsa_pkcs1_unencrypted.key").getFile()), null);
        Assertions.assertNotNull((Object)key);
    }

    @Test
    public void testPkcs8UnencryptedRsa() throws Exception {
        PrivateKey key = SslContext.toPrivateKey((File)new File(this.getClass().getResource("rsa_pkcs8_unencrypted.key").getFile()), null);
        Assertions.assertNotNull((Object)key);
    }

    @Test
    public void testPkcs8AesEncryptedRsa() throws Exception {
        PrivateKey key = SslContext.toPrivateKey((File)new File(this.getClass().getResource("rsa_pkcs8_aes_encrypted.key").getFile()), (String)"example");
        Assertions.assertNotNull((Object)key);
    }

    @Test
    public void testPkcs8Des3EncryptedRsa() throws Exception {
        PrivateKey key = SslContext.toPrivateKey((File)new File(this.getClass().getResource("rsa_pkcs8_des3_encrypted.key").getFile()), (String)"example");
        Assertions.assertNotNull((Object)key);
    }

    @Test
    public void testPkcs8Pbes2() throws Exception {
        PrivateKey key = SslContext.toPrivateKey((File)new File(this.getClass().getResource("rsa_pbes2_enc_pkcs8.key").getFile()), (String)"12345678", (boolean)false);
        Assertions.assertNotNull((Object)key);
    }

    @Test
    public void testPkcs1UnencryptedRsaEmptyPassword() throws Exception {
        Assertions.assertThrows(IOException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                SslContext.toPrivateKey((File)new File(this.getClass().getResource("rsa_pkcs1_unencrypted.key").getFile()), (String)"");
            }
        });
    }

    @Test
    public void testPkcs1Des3EncryptedRsa() throws Exception {
        PrivateKey key = SslContext.toPrivateKey((File)new File(this.getClass().getResource("rsa_pkcs1_des3_encrypted.key").getFile()), (String)"example");
        Assertions.assertNotNull((Object)key);
    }

    @Test
    public void testPkcs1AesEncryptedRsa() throws Exception {
        PrivateKey key = SslContext.toPrivateKey((File)new File(this.getClass().getResource("rsa_pkcs1_aes_encrypted.key").getFile()), (String)"example");
        Assertions.assertNotNull((Object)key);
    }

    @Test
    public void testPkcs1Des3EncryptedRsaNoPassword() throws Exception {
        Assertions.assertThrows(InvalidKeySpecException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                SslContext.toPrivateKey((File)new File(this.getClass().getResource("rsa_pkcs1_des3_encrypted.key").getFile()), null);
            }
        });
    }

    @Test
    public void testPkcs1AesEncryptedRsaNoPassword() throws Exception {
        Assertions.assertThrows(InvalidKeySpecException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                SslContext.toPrivateKey((File)new File(this.getClass().getResource("rsa_pkcs1_aes_encrypted.key").getFile()), null);
            }
        });
    }

    @Test
    public void testPkcs1Des3EncryptedRsaEmptyPassword() throws Exception {
        Assertions.assertThrows(IOException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                SslContext.toPrivateKey((File)new File(this.getClass().getResource("rsa_pkcs1_des3_encrypted.key").getFile()), (String)"");
            }
        });
    }

    @Test
    public void testPkcs1AesEncryptedRsaEmptyPassword() throws Exception {
        Assertions.assertThrows(IOException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                SslContext.toPrivateKey((File)new File(this.getClass().getResource("rsa_pkcs1_aes_encrypted.key").getFile()), (String)"");
            }
        });
    }

    @Test
    public void testPkcs1Des3EncryptedRsaWrongPassword() throws Exception {
        Assertions.assertThrows(IOException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                SslContext.toPrivateKey((File)new File(this.getClass().getResource("rsa_pkcs1_des3_encrypted.key").getFile()), (String)"wrong");
            }
        });
    }

    @Test
    public void testPkcs1AesEncryptedRsaWrongPassword() throws Exception {
        Assertions.assertThrows(IOException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                SslContext.toPrivateKey((File)new File(this.getClass().getResource("rsa_pkcs1_aes_encrypted.key").getFile()), (String)"wrong");
            }
        });
    }

    @Test
    public void testPkcs1UnencryptedDsa() throws Exception {
        PrivateKey key = SslContext.toPrivateKey((File)new File(this.getClass().getResource("dsa_pkcs1_unencrypted.key").getFile()), null);
        Assertions.assertNotNull((Object)key);
    }

    @Test
    public void testPkcs1UnencryptedDsaEmptyPassword() throws Exception {
        Assertions.assertThrows(IOException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                PrivateKey key = SslContext.toPrivateKey((File)new File(this.getClass().getResource("dsa_pkcs1_unencrypted.key").getFile()), (String)"");
            }
        });
    }

    @Test
    public void testPkcs1Des3EncryptedDsa() throws Exception {
        PrivateKey key = SslContext.toPrivateKey((File)new File(this.getClass().getResource("dsa_pkcs1_des3_encrypted.key").getFile()), (String)"example");
        Assertions.assertNotNull((Object)key);
    }

    @Test
    public void testPkcs1AesEncryptedDsa() throws Exception {
        PrivateKey key = SslContext.toPrivateKey((File)new File(this.getClass().getResource("dsa_pkcs1_aes_encrypted.key").getFile()), (String)"example");
        Assertions.assertNotNull((Object)key);
    }

    @Test
    public void testPkcs1Des3EncryptedDsaNoPassword() throws Exception {
        Assertions.assertThrows(InvalidKeySpecException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                SslContext.toPrivateKey((File)new File(this.getClass().getResource("dsa_pkcs1_des3_encrypted.key").getFile()), null);
            }
        });
    }

    @Test
    public void testPkcs1AesEncryptedDsaNoPassword() throws Exception {
        Assertions.assertThrows(InvalidKeySpecException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                SslContext.toPrivateKey((File)new File(this.getClass().getResource("dsa_pkcs1_aes_encrypted.key").getFile()), null);
            }
        });
    }

    @Test
    public void testPkcs1Des3EncryptedDsaEmptyPassword() throws Exception {
        Assertions.assertThrows(IOException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                SslContext.toPrivateKey((File)new File(this.getClass().getResource("dsa_pkcs1_des3_encrypted.key").getFile()), (String)"");
            }
        });
    }

    @Test
    public void testPkcs1AesEncryptedDsaEmptyPassword() throws Exception {
        Assertions.assertThrows(IOException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                SslContext.toPrivateKey((File)new File(this.getClass().getResource("dsa_pkcs1_aes_encrypted.key").getFile()), (String)"");
            }
        });
    }

    @Test
    public void testPkcs1Des3EncryptedDsaWrongPassword() throws Exception {
        Assertions.assertThrows(IOException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                SslContext.toPrivateKey((File)new File(this.getClass().getResource("dsa_pkcs1_des3_encrypted.key").getFile()), (String)"wrong");
            }
        });
    }

    @Test
    public void testPkcs1AesEncryptedDsaWrongPassword() throws Exception {
        Assertions.assertThrows(IOException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                SslContext.toPrivateKey((File)new File(this.getClass().getResource("dsa_pkcs1_aes_encrypted.key").getFile()), (String)"wrong");
            }
        });
    }
}

