/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalIoHandler;
import io.netty.channel.local.LocalServerChannel;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslContextOption;
import io.netty.handler.ssl.OpenSslParametersUtil;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslContextOption;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.SslProvider;
import io.netty.pkitesting.CertificateBuilder;
import io.netty.pkitesting.X509Bundle;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Promise;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLParameters;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledForJreRange;
import org.junit.jupiter.api.condition.EnabledIf;
import org.junit.jupiter.api.condition.JRE;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

public class PkiTestingTlsTest {
    static List<Arguments> classicalAlgorithms() {
        ArrayList<SslProvider> providers = new ArrayList<SslProvider>();
        if (SslProvider.isTlsv13Supported((SslProvider)SslProvider.JDK)) {
            providers.add(SslProvider.JDK);
        }
        if (OpenSsl.isAvailable() && OpenSsl.supportsKeyManagerFactory() && OpenSsl.isTlsv13Supported()) {
            providers.add(SslProvider.OPENSSL);
        }
        ArrayList<Arguments> args = new ArrayList<Arguments>();
        for (SslProvider provider : providers) {
            ArrayList<CertificateBuilder.Algorithm> algs = new ArrayList<CertificateBuilder.Algorithm>();
            algs.add(CertificateBuilder.Algorithm.rsa2048);
            algs.add(CertificateBuilder.Algorithm.ecp256);
            for (CertificateBuilder.Algorithm alg : algs) {
                args.add(Arguments.of((Object[])new Object[]{provider, alg}));
            }
        }
        return args;
    }

    @ParameterizedTest
    @MethodSource(value={"classicalAlgorithms"})
    public void connectWithClassicalAlgorithms(SslProvider provider, CertificateBuilder.Algorithm algorithm) throws Exception {
        X509Bundle cert = new CertificateBuilder().algorithm(algorithm).setIsCertificateAuthority(true).subject("CN=localhost").buildSelfSigned();
        SslContext serverContext = SslContextBuilder.forServer((KeyManagerFactory)cert.toKeyManagerFactory()).sslProvider(provider).build();
        SslContext clientContext = SslContextBuilder.forClient().trustManager(cert.toTrustManagerFactory()).sslProvider(provider).serverName((SNIServerName)new SNIHostName("localhost")).protocols(new String[]{"TLSv1.3"}).build();
        this.testTlsConnection(serverContext, clientContext, null);
    }

    @EnabledForJreRange(min=JRE.JAVA_15)
    @Test
    public void connectWithEd25519() throws Exception {
        X509Bundle cert = new CertificateBuilder().algorithm(CertificateBuilder.Algorithm.ed25519).setIsCertificateAuthority(true).subject("CN=localhost").buildSelfSigned();
        SslProvider provider = SslProvider.JDK;
        SslContext serverContext = SslContextBuilder.forServer((KeyManagerFactory)cert.toKeyManagerFactory()).sslProvider(provider).build();
        SslContext clientContext = SslContextBuilder.forClient().trustManager(cert.toTrustManagerFactory()).sslProvider(provider).serverName((SNIServerName)new SNIHostName("localhost")).protocols(new String[]{"TLSv1.3"}).build();
        this.testTlsConnection(serverContext, clientContext, null);
    }

    static boolean isBoringSSLAvailable() {
        return OpenSsl.isBoringSSL() && OpenSsl.isTlsv13Supported();
    }

    @EnabledForJreRange(min=JRE.JAVA_24)
    @EnabledIf(value="isBoringSSLAvailable")
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void connectWithX25519MLKEM768(boolean configureViaParameter) throws Exception {
        X509Bundle cert = new CertificateBuilder().algorithm(CertificateBuilder.Algorithm.ecp256).setIsCertificateAuthority(true).subject("CN=localhost").buildSelfSigned();
        String[] ciphers = new String[]{"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_AES_256_GCM_SHA384", "TLS_CHACHA20_POLY1305_SHA256"};
        String[] groups = new String[]{"X25519MLKEM768"};
        SslContextBuilder serverBuilder = SslContextBuilder.forServer((KeyManagerFactory)cert.toKeyManagerFactory()).sslProvider(SslProvider.OPENSSL).protocols(new String[]{"TLSv1.3"}).ciphers(Arrays.asList(ciphers));
        if (!configureViaParameter) {
            serverBuilder.option((SslContextOption)OpenSslContextOption.GROUPS, (Object)((String[])groups.clone()));
        }
        SslContext serverContext = serverBuilder.build();
        SslContextBuilder clientBuilder = SslContextBuilder.forClient().trustManager(cert.toTrustManagerFactory()).sslProvider(SslProvider.OPENSSL).serverName((SNIServerName)new SNIHostName("localhost")).protocols(new String[]{"TLSv1.3"}).ciphers(Arrays.asList(ciphers));
        if (!configureViaParameter) {
            clientBuilder.option((SslContextOption)OpenSslContextOption.GROUPS, (Object)((String[])groups.clone()));
        }
        SslContext clientContext = clientBuilder.build();
        this.testTlsConnection(serverContext, clientContext, configureViaParameter ? (String[])groups.clone() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testTlsConnection(final SslContext serverContext, final SslContext clientContext, final String[] groups) throws InterruptedException {
        MultiThreadIoEventLoopGroup group = new MultiThreadIoEventLoopGroup(1, LocalIoHandler.newFactory());
        LocalAddress serverAddress = new LocalAddress(this.getClass());
        Channel serverChannel = null;
        Channel clientChannel = null;
        try {
            serverChannel = ((ServerBootstrap)new ServerBootstrap().channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    SslHandler handler = serverContext.newHandler(ch.alloc());
                    if (groups != null) {
                        SSLParameters parameters = handler.engine().getSSLParameters();
                        OpenSslParametersUtil.setNamesGroups((SSLParameters)parameters, (String[])groups);
                        handler.engine().setSSLParameters(parameters);
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{handler});
                }
            }).group((EventLoopGroup)group).bind((SocketAddress)serverAddress).sync().channel();
            final Promise promise = group.next().newPromise();
            clientChannel = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(LocalChannel.class)).group((EventLoopGroup)group)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    SslHandler handler = clientContext.newHandler(ch.alloc(), "localhost", 0);
                    if (groups != null) {
                        SSLParameters parameters = handler.engine().getSSLParameters();
                        OpenSslParametersUtil.setNamesGroups((SSLParameters)parameters, (String[])groups);
                        handler.engine().setSSLParameters(parameters);
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{handler}).addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                            if (evt instanceof SslHandshakeCompletionEvent) {
                                SslHandshakeCompletionEvent shce = (SslHandshakeCompletionEvent)evt;
                                if (shce.isSuccess()) {
                                    promise.setSuccess((Object)shce);
                                } else {
                                    promise.setFailure(shce.cause());
                                }
                                return;
                            }
                            super.userEventTriggered(ctx, evt);
                        }

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                            if (!promise.tryFailure(cause)) {
                                ctx.fireExceptionCaught(cause);
                            }
                        }
                    }});
                }
            })).connect((SocketAddress)serverAddress).sync().channel();
            promise.sync();
        }
        finally {
            if (clientChannel != null) {
                clientChannel.close();
            }
            if (serverChannel != null) {
                serverChannel.close();
            }
            if (clientChannel != null) {
                clientChannel.closeFuture().sync();
            }
            if (serverChannel != null) {
                serverChannel.closeFuture().sync();
            }
            group.shutdownGracefully(10L, 1000L, TimeUnit.MILLISECONDS).syncUninterruptibly();
            ReferenceCountUtil.release((Object)clientContext);
            ReferenceCountUtil.release((Object)serverContext);
        }
    }
}

