/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.PemEncoded;
import io.netty.handler.ssl.PemPrivateKey;
import io.netty.handler.ssl.PemX509Certificate;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.CachedSelfSignedCertificate;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.util.ReferenceCountUtil;
import java.nio.file.Files;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class PemEncodedTest {
    @Test
    public void testPemEncodedOpenSsl() throws Exception {
        PemEncodedTest.testPemEncoded(SslProvider.OPENSSL);
    }

    @Test
    public void testPemEncodedOpenSslRef() throws Exception {
        PemEncodedTest.testPemEncoded(SslProvider.OPENSSL_REFCNT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testPemEncoded(SslProvider provider) throws Exception {
        OpenSsl.ensureAvailability();
        Assumptions.assumeFalse((boolean)OpenSsl.useKeyManagerFactory());
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        PemPrivateKey pemKey = PemPrivateKey.valueOf((byte[])Files.readAllBytes(ssc.privateKey().toPath()));
        PemX509Certificate pemCert = PemX509Certificate.valueOf((byte[])Files.readAllBytes(ssc.certificate().toPath()));
        SslContext context = SslContextBuilder.forServer((PrivateKey)pemKey, (X509Certificate[])new X509Certificate[]{pemCert}).sslProvider(provider).build();
        Assertions.assertEquals((int)1, (int)pemKey.refCnt());
        Assertions.assertEquals((int)1, (int)pemCert.refCnt());
        try {
            Assertions.assertInstanceOf(ReferenceCountedOpenSslContext.class, (Object)context);
        }
        finally {
            ReferenceCountUtil.release((Object)context);
            PemEncodedTest.assertRelease((PemEncoded)pemKey);
            PemEncodedTest.assertRelease((PemEncoded)pemCert);
        }
    }

    @Test
    public void testEncodedReturnsNull() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                PemPrivateKey.toPEM((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, (boolean)true, (PrivateKey)new PrivateKey(){

                    @Override
                    public String getAlgorithm() {
                        return null;
                    }

                    @Override
                    public String getFormat() {
                        return null;
                    }

                    @Override
                    public byte[] getEncoded() {
                        return null;
                    }
                });
            }
        });
    }

    private static void assertRelease(PemEncoded encoded) {
        Assertions.assertTrue((boolean)encoded.release());
    }
}

