/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.OpenSslCachingKeyMaterialProviderTest;
import io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import io.netty.handler.ssl.OpenSslX509KeyManagerFactory;
import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;

public class OpenSslX509KeyManagerFactoryProviderTest
extends OpenSslCachingKeyMaterialProviderTest {
    @Override
    protected KeyManagerFactory newKeyManagerFactory() throws Exception {
        char[] password = "example".toCharArray();
        KeyStore keystore = KeyStore.getInstance("PKCS12");
        try (InputStream resourceAsStream = this.getClass().getResourceAsStream("mutual_auth_server.p12");){
            keystore.load(resourceAsStream, password);
            OpenSslX509KeyManagerFactory kmf = new OpenSslX509KeyManagerFactory();
            kmf.init(keystore, password);
            OpenSslX509KeyManagerFactory openSslX509KeyManagerFactory = kmf;
            return openSslX509KeyManagerFactory;
        }
    }

    @Override
    protected OpenSslKeyMaterialProvider newMaterialProvider(KeyManagerFactory kmf, String password) {
        return ((OpenSslX509KeyManagerFactory)kmf).newProvider();
    }
}

