/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

final class OpenSslTest {
    OpenSslTest() {
    }

    @Test
    void testDefaultCiphers() {
        if (!OpenSsl.isTlsv13Supported()) {
            Assertions.assertTrue((OpenSsl.DEFAULT_CIPHERS.size() <= SslUtils.DEFAULT_CIPHER_SUITES.length ? 1 : 0) != 0);
        }
    }

    @Test
    void availableJavaCipherSuitesMustNotContainNullOrEmptyElement() {
        OpenSsl.availableJavaCipherSuites().forEach(suite -> {
            Assertions.assertNotNull((Object)suite);
            Assertions.assertFalse((boolean)suite.isEmpty());
        });
    }

    @Test
    void availableOpenSslCipherSuitesMustNotContainNullOrEmptyElement() {
        OpenSsl.availableOpenSslCipherSuites().forEach(suite -> {
            Assertions.assertNotNull((Object)suite);
            Assertions.assertFalse((boolean)suite.isEmpty());
        });
    }
}

