/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslEngine;
import io.netty.handler.ssl.OpenSslKeyMaterial;
import io.netty.handler.ssl.OpenSslKeyMaterialManager;
import io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.EmptyArrays;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509ExtendedKeyManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OpenSslKeyMaterialManagerTest {
    @Test
    public void testChooseClientAliasReturnsNull() throws SSLException {
        OpenSsl.ensureAvailability();
        X509ExtendedKeyManager keyManager = new X509ExtendedKeyManager(){

            @Override
            public String[] getClientAliases(String s, Principal[] principals) {
                return EmptyArrays.EMPTY_STRINGS;
            }

            @Override
            public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
                return null;
            }

            @Override
            public String[] getServerAliases(String s, Principal[] principals) {
                return EmptyArrays.EMPTY_STRINGS;
            }

            @Override
            public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
                return null;
            }

            @Override
            public X509Certificate[] getCertificateChain(String s) {
                return EmptyArrays.EMPTY_X509_CERTIFICATES;
            }

            @Override
            public PrivateKey getPrivateKey(String s) {
                return null;
            }
        };
        OpenSslKeyMaterialManager manager = new OpenSslKeyMaterialManager(new OpenSslKeyMaterialProvider(keyManager, null){

            OpenSslKeyMaterial chooseKeyMaterial(ByteBufAllocator allocator, String alias) throws Exception {
                Assertions.fail((String)"Should not be called when alias is null");
                return null;
            }
        }, false);
        SslContext context = SslContextBuilder.forClient().sslProvider(SslProvider.OPENSSL).build();
        OpenSslEngine engine = (OpenSslEngine)context.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        manager.setKeyMaterialClientSide((ReferenceCountedOpenSslEngine)engine, EmptyArrays.EMPTY_STRINGS, null);
        ReferenceCountUtil.release((Object)engine);
        ReferenceCountUtil.release((Object)context);
    }
}

