/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalIoHandler;
import io.netty.channel.local.LocalServerChannel;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslCertificateCompressionAlgorithm;
import io.netty.handler.ssl.OpenSslCertificateCompressionConfig;
import io.netty.handler.ssl.OpenSslContextOption;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslContextOption;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.internal.tcnative.CertificateCompressionAlgo;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Promise;
import java.net.SocketAddress;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class OpenSslCertificateCompressionTest {
    private static SelfSignedCertificate cert;
    private TestCertCompressionAlgo testZLibAlgoServer;
    private TestCertCompressionAlgo testBrotliAlgoServer;
    private TestCertCompressionAlgo testZstdAlgoServer;
    private TestCertCompressionAlgo testZlibAlgoClient;
    private TestCertCompressionAlgo testBrotliAlgoClient;

    @BeforeAll
    public static void init() throws Exception {
        Assumptions.assumeTrue((boolean)OpenSsl.isTlsv13Supported());
        cert = new SelfSignedCertificate();
    }

    @BeforeEach
    public void refreshAlgos() {
        this.testZLibAlgoServer = new TestCertCompressionAlgo(CertificateCompressionAlgo.TLS_EXT_CERT_COMPRESSION_ZLIB);
        this.testBrotliAlgoServer = new TestCertCompressionAlgo(CertificateCompressionAlgo.TLS_EXT_CERT_COMPRESSION_BROTLI);
        this.testZstdAlgoServer = new TestCertCompressionAlgo(CertificateCompressionAlgo.TLS_EXT_CERT_COMPRESSION_ZSTD);
        this.testZlibAlgoClient = new TestCertCompressionAlgo(CertificateCompressionAlgo.TLS_EXT_CERT_COMPRESSION_ZLIB);
        this.testBrotliAlgoClient = new TestCertCompressionAlgo(CertificateCompressionAlgo.TLS_EXT_CERT_COMPRESSION_BROTLI);
    }

    @Test
    public void testSimple() throws Throwable {
        Assumptions.assumeTrue((OpenSsl.isBoringSSL() || OpenSsl.isAWSLC() ? 1 : 0) != 0);
        SslContext clientSslContext = this.buildClientContext(OpenSslCertificateCompressionConfig.newBuilder().addAlgorithm((OpenSslCertificateCompressionAlgorithm)this.testBrotliAlgoClient, OpenSslCertificateCompressionConfig.AlgorithmMode.Decompress).build());
        SslContext serverSslContext = this.buildServerContext(OpenSslCertificateCompressionConfig.newBuilder().addAlgorithm((OpenSslCertificateCompressionAlgorithm)this.testBrotliAlgoServer, OpenSslCertificateCompressionConfig.AlgorithmMode.Compress).build());
        this.runCertCompressionTest(clientSslContext, serverSslContext);
        this.assertCompress(this.testBrotliAlgoServer);
        this.assertDecompress(this.testBrotliAlgoClient);
    }

    @Test
    public void testServerPriority() throws Throwable {
        Assumptions.assumeTrue((OpenSsl.isBoringSSL() || OpenSsl.isAWSLC() ? 1 : 0) != 0);
        SslContext clientSslContext = this.buildClientContext(OpenSslCertificateCompressionConfig.newBuilder().addAlgorithm((OpenSslCertificateCompressionAlgorithm)this.testBrotliAlgoClient, OpenSslCertificateCompressionConfig.AlgorithmMode.Decompress).addAlgorithm((OpenSslCertificateCompressionAlgorithm)this.testZlibAlgoClient, OpenSslCertificateCompressionConfig.AlgorithmMode.Decompress).build());
        SslContext serverSslContext = this.buildServerContext(OpenSslCertificateCompressionConfig.newBuilder().addAlgorithm((OpenSslCertificateCompressionAlgorithm)this.testZLibAlgoServer, OpenSslCertificateCompressionConfig.AlgorithmMode.Compress).addAlgorithm((OpenSslCertificateCompressionAlgorithm)this.testBrotliAlgoServer, OpenSslCertificateCompressionConfig.AlgorithmMode.Compress).build());
        this.runCertCompressionTest(clientSslContext, serverSslContext);
        this.assertCompress(this.testZLibAlgoServer);
        this.assertDecompress(this.testZlibAlgoClient);
        this.assertNone(this.testBrotliAlgoClient, this.testBrotliAlgoServer);
    }

    @Test
    public void testServerPriorityReverse() throws Throwable {
        Assumptions.assumeTrue((OpenSsl.isBoringSSL() || OpenSsl.isAWSLC() ? 1 : 0) != 0);
        SslContext clientSslContext = this.buildClientContext(OpenSslCertificateCompressionConfig.newBuilder().addAlgorithm((OpenSslCertificateCompressionAlgorithm)this.testBrotliAlgoClient, OpenSslCertificateCompressionConfig.AlgorithmMode.Decompress).addAlgorithm((OpenSslCertificateCompressionAlgorithm)this.testZlibAlgoClient, OpenSslCertificateCompressionConfig.AlgorithmMode.Decompress).build());
        SslContext serverSslContext = this.buildServerContext(OpenSslCertificateCompressionConfig.newBuilder().addAlgorithm((OpenSslCertificateCompressionAlgorithm)this.testBrotliAlgoServer, OpenSslCertificateCompressionConfig.AlgorithmMode.Compress).addAlgorithm((OpenSslCertificateCompressionAlgorithm)this.testZLibAlgoServer, OpenSslCertificateCompressionConfig.AlgorithmMode.Compress).build());
        this.runCertCompressionTest(clientSslContext, serverSslContext);
        this.assertCompress(this.testBrotliAlgoServer);
        this.assertDecompress(this.testBrotliAlgoClient);
        this.assertNone(this.testZLibAlgoServer, this.testZlibAlgoClient);
    }

    @Test
    public void testFailedNegotiation() throws Throwable {
        Assumptions.assumeTrue((OpenSsl.isBoringSSL() || OpenSsl.isAWSLC() ? 1 : 0) != 0);
        SslContext clientSslContext = this.buildClientContext(OpenSslCertificateCompressionConfig.newBuilder().addAlgorithm((OpenSslCertificateCompressionAlgorithm)this.testBrotliAlgoClient, OpenSslCertificateCompressionConfig.AlgorithmMode.Decompress).addAlgorithm((OpenSslCertificateCompressionAlgorithm)this.testZlibAlgoClient, OpenSslCertificateCompressionConfig.AlgorithmMode.Decompress).build());
        SslContext serverSslContext = this.buildServerContext(OpenSslCertificateCompressionConfig.newBuilder().addAlgorithm((OpenSslCertificateCompressionAlgorithm)this.testZstdAlgoServer, OpenSslCertificateCompressionConfig.AlgorithmMode.Compress).build());
        this.runCertCompressionTest(clientSslContext, serverSslContext);
        this.assertNone(this.testBrotliAlgoClient, this.testZlibAlgoClient, this.testZstdAlgoServer);
    }

    @Test
    public void testAlgoFailure() throws Throwable {
        Assumptions.assumeTrue((OpenSsl.isBoringSSL() || OpenSsl.isAWSLC() ? 1 : 0) != 0);
        TestCertCompressionAlgo badZlibAlgoClient = new TestCertCompressionAlgo(CertificateCompressionAlgo.TLS_EXT_CERT_COMPRESSION_ZLIB){

            @Override
            public byte[] decompress(SSLEngine engine, int uncompressed_len, byte[] input) {
                return input;
            }
        };
        final SslContext clientSslContext = this.buildClientContext(OpenSslCertificateCompressionConfig.newBuilder().addAlgorithm((OpenSslCertificateCompressionAlgorithm)badZlibAlgoClient, OpenSslCertificateCompressionConfig.AlgorithmMode.Decompress).build());
        final SslContext serverSslContext = this.buildServerContext(OpenSslCertificateCompressionConfig.newBuilder().addAlgorithm((OpenSslCertificateCompressionAlgorithm)this.testZLibAlgoServer, OpenSslCertificateCompressionConfig.AlgorithmMode.Compress).build());
        Assertions.assertThrows(SSLHandshakeException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                OpenSslCertificateCompressionTest.this.runCertCompressionTest(clientSslContext, serverSslContext);
            }
        });
    }

    @Test
    public void testAlgoException() throws Throwable {
        Assumptions.assumeTrue((OpenSsl.isBoringSSL() || OpenSsl.isAWSLC() ? 1 : 0) != 0);
        TestCertCompressionAlgo badZlibAlgoClient = new TestCertCompressionAlgo(CertificateCompressionAlgo.TLS_EXT_CERT_COMPRESSION_ZLIB){

            @Override
            public byte[] decompress(SSLEngine engine, int uncompressed_len, byte[] input) {
                throw new RuntimeException("broken");
            }
        };
        final SslContext clientSslContext = this.buildClientContext(OpenSslCertificateCompressionConfig.newBuilder().addAlgorithm((OpenSslCertificateCompressionAlgorithm)badZlibAlgoClient, OpenSslCertificateCompressionConfig.AlgorithmMode.Decompress).build());
        final SslContext serverSslContext = this.buildServerContext(OpenSslCertificateCompressionConfig.newBuilder().addAlgorithm((OpenSslCertificateCompressionAlgorithm)this.testZLibAlgoServer, OpenSslCertificateCompressionConfig.AlgorithmMode.Compress).build());
        Assertions.assertThrows(SSLHandshakeException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                OpenSslCertificateCompressionTest.this.runCertCompressionTest(clientSslContext, serverSslContext);
            }
        });
    }

    @Test
    public void testTlsLessThan13() throws Throwable {
        Assumptions.assumeTrue((OpenSsl.isBoringSSL() || OpenSsl.isAWSLC() ? 1 : 0) != 0);
        SslContext clientSslContext = SslContextBuilder.forClient().sslProvider(SslProvider.OPENSSL).protocols(new String[]{"TLSv1.2"}).trustManager(InsecureTrustManagerFactory.INSTANCE).option((SslContextOption)OpenSslContextOption.CERTIFICATE_COMPRESSION_ALGORITHMS, (Object)OpenSslCertificateCompressionConfig.newBuilder().addAlgorithm((OpenSslCertificateCompressionAlgorithm)this.testBrotliAlgoClient, OpenSslCertificateCompressionConfig.AlgorithmMode.Decompress).build()).build();
        SslContext serverSslContext = SslContextBuilder.forServer((PrivateKey)cert.key(), (X509Certificate[])new X509Certificate[]{cert.cert()}).sslProvider(SslProvider.OPENSSL).protocols(new String[]{"TLSv1.2"}).option((SslContextOption)OpenSslContextOption.CERTIFICATE_COMPRESSION_ALGORITHMS, (Object)OpenSslCertificateCompressionConfig.newBuilder().addAlgorithm((OpenSslCertificateCompressionAlgorithm)this.testBrotliAlgoServer, OpenSslCertificateCompressionConfig.AlgorithmMode.Compress).build()).build();
        this.runCertCompressionTest(clientSslContext, serverSslContext);
        this.assertNone(this.testBrotliAlgoClient, this.testBrotliAlgoServer);
    }

    @Test
    public void testDuplicateAdd() throws Throwable {
        Assumptions.assumeTrue((OpenSsl.isBoringSSL() || OpenSsl.isAWSLC() ? 1 : 0) != 0);
        Assertions.assertThrows(Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                OpenSslCertificateCompressionTest.this.buildClientContext(OpenSslCertificateCompressionConfig.newBuilder().addAlgorithm((OpenSslCertificateCompressionAlgorithm)OpenSslCertificateCompressionTest.this.testBrotliAlgoClient, OpenSslCertificateCompressionConfig.AlgorithmMode.Decompress).addAlgorithm((OpenSslCertificateCompressionAlgorithm)OpenSslCertificateCompressionTest.this.testBrotliAlgoClient, OpenSslCertificateCompressionConfig.AlgorithmMode.Compress).build());
            }
        });
        Assertions.assertThrows(Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                OpenSslCertificateCompressionTest.this.buildServerContext(OpenSslCertificateCompressionConfig.newBuilder().addAlgorithm((OpenSslCertificateCompressionAlgorithm)OpenSslCertificateCompressionTest.this.testBrotliAlgoServer, OpenSslCertificateCompressionConfig.AlgorithmMode.Compress).addAlgorithm((OpenSslCertificateCompressionAlgorithm)OpenSslCertificateCompressionTest.this.testBrotliAlgoServer, OpenSslCertificateCompressionConfig.AlgorithmMode.Both).build());
            }
        });
    }

    @Test
    public void testNotBoringAdd() throws Throwable {
        Assumptions.assumeTrue((!OpenSsl.isBoringSSL() && !OpenSsl.isAWSLC() ? 1 : 0) != 0);
        Assertions.assertThrows(Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                OpenSslCertificateCompressionTest.this.buildClientContext(OpenSslCertificateCompressionConfig.newBuilder().addAlgorithm((OpenSslCertificateCompressionAlgorithm)OpenSslCertificateCompressionTest.this.testBrotliAlgoClient, OpenSslCertificateCompressionConfig.AlgorithmMode.Decompress).build());
            }
        });
        Assertions.assertThrows(Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                OpenSslCertificateCompressionTest.this.buildServerContext(OpenSslCertificateCompressionConfig.newBuilder().addAlgorithm((OpenSslCertificateCompressionAlgorithm)OpenSslCertificateCompressionTest.this.testBrotliAlgoServer, OpenSslCertificateCompressionConfig.AlgorithmMode.Compress).build());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCertCompressionTest(SslContext clientSslContext, SslContext serverSslContext) throws Throwable {
        MultiThreadIoEventLoopGroup group = new MultiThreadIoEventLoopGroup(LocalIoHandler.newFactory());
        Promise clientPromise = group.next().newPromise();
        Promise serverPromise = group.next().newPromise();
        try {
            ServerBootstrap sb = new ServerBootstrap();
            ((ServerBootstrap)sb.group((EventLoopGroup)group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new CertCompressionTestChannelInitializer((Promise<Object>)serverPromise, serverSslContext));
            Channel serverChannel = sb.bind((SocketAddress)new LocalAddress("testCertificateCompression")).syncUninterruptibly().channel();
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)group)).channel(LocalChannel.class)).handler((ChannelHandler)new CertCompressionTestChannelInitializer((Promise<Object>)clientPromise, clientSslContext));
            Channel clientChannel = bootstrap.connect(serverChannel.localAddress()).syncUninterruptibly().channel();
            Assertions.assertTrue((boolean)clientPromise.await(5L, TimeUnit.SECONDS), (String)"client timeout");
            Assertions.assertTrue((boolean)serverPromise.await(5L, TimeUnit.SECONDS), (String)"server timeout");
            clientPromise.sync();
            serverPromise.sync();
            clientChannel.close().syncUninterruptibly();
            serverChannel.close().syncUninterruptibly();
        }
        finally {
            group.shutdownGracefully();
            ReferenceCountUtil.release((Object)clientSslContext);
            ReferenceCountUtil.release((Object)serverSslContext);
        }
    }

    private SslContext buildServerContext(OpenSslCertificateCompressionConfig compressionConfig) throws SSLException {
        return SslContextBuilder.forServer((PrivateKey)cert.key(), (X509Certificate[])new X509Certificate[]{cert.cert()}).sslProvider(SslProvider.OPENSSL).protocols(new String[]{"TLSv1.3"}).option((SslContextOption)OpenSslContextOption.CERTIFICATE_COMPRESSION_ALGORITHMS, (Object)compressionConfig).build();
    }

    private SslContext buildClientContext(OpenSslCertificateCompressionConfig compressionConfig) throws SSLException {
        return SslContextBuilder.forClient().sslProvider(SslProvider.OPENSSL).protocols(new String[]{"TLSv1.3"}).trustManager(InsecureTrustManagerFactory.INSTANCE).option((SslContextOption)OpenSslContextOption.CERTIFICATE_COMPRESSION_ALGORITHMS, (Object)compressionConfig).build();
    }

    private void assertCompress(TestCertCompressionAlgo algo) {
        Assertions.assertTrue((algo.compressCalled && !algo.decompressCalled ? 1 : 0) != 0);
    }

    private void assertDecompress(TestCertCompressionAlgo algo) {
        Assertions.assertTrue((!algo.compressCalled && algo.decompressCalled ? 1 : 0) != 0);
    }

    private void assertNone(TestCertCompressionAlgo ... algos) {
        for (TestCertCompressionAlgo algo : algos) {
            Assertions.assertTrue((!algo.compressCalled && !algo.decompressCalled ? 1 : 0) != 0);
        }
    }

    private static class TestCertCompressionAlgo
    implements OpenSslCertificateCompressionAlgorithm {
        private static final int BASE_PADDING_SIZE = 10;
        public boolean compressCalled;
        public boolean decompressCalled;
        private final int algorithmId;

        TestCertCompressionAlgo(int algorithmId) {
            this.algorithmId = algorithmId;
        }

        public byte[] compress(SSLEngine engine, byte[] input) throws Exception {
            this.compressCalled = true;
            byte[] output = new byte[input.length + 10 + this.algorithmId];
            System.arraycopy(input, 0, output, 10 + this.algorithmId, input.length);
            return output;
        }

        public byte[] decompress(SSLEngine engine, int uncompressed_len, byte[] input) {
            this.decompressCalled = true;
            byte[] output = new byte[input.length - (10 + this.algorithmId)];
            System.arraycopy(input, 10 + this.algorithmId, output, 0, output.length);
            return output;
        }

        public int algorithmId() {
            return this.algorithmId;
        }
    }

    private static class CertCompressionTestChannelInitializer
    extends ChannelInitializer<Channel> {
        private final Promise<Object> channelPromise;
        private final SslContext sslContext;

        CertCompressionTestChannelInitializer(Promise<Object> channelPromise, SslContext sslContext) {
            this.channelPromise = channelPromise;
            this.sslContext = sslContext;
        }

        protected void initChannel(Channel ch) {
            ChannelPipeline pipeline = ch.pipeline();
            pipeline.addLast(new ChannelHandler[]{this.sslContext.newHandler(ch.alloc())});
            pipeline.addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<Object>(){

                public void channelRead0(ChannelHandlerContext ctx, Object msg) {
                }

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                    if (evt instanceof SslHandshakeCompletionEvent) {
                        if (((SslHandshakeCompletionEvent)evt).isSuccess()) {
                            channelPromise.trySuccess(evt);
                        } else {
                            channelPromise.tryFailure(((SslHandshakeCompletionEvent)evt).cause());
                        }
                    }
                    ctx.fireUserEventTriggered(evt);
                }
            }});
        }
    }
}

