/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.util.concurrent.atomic.AtomicInteger;

public final class MockAlternativeKeyProvider
extends Provider {
    private static final String PROVIDER_NAME = "MockAlternativeKeyProvider";
    private static final double PROVIDER_VERSION = 1.0;
    private static final String PROVIDER_INFO = "Mock provider simulating alternative key providers";
    private static final AtomicInteger signatureOperations = new AtomicInteger(0);

    MockAlternativeKeyProvider() {
        super(PROVIDER_NAME, 1.0, PROVIDER_INFO);
        this.put("Signature.RSASSA-PSS", MockRsaPssSignature.class.getName());
        this.put("Signature.SHA1withRSA", MockSha1WithRsaSignature.class.getName());
        this.put("Signature.SHA256withRSA", MockSha256WithRsaSignature.class.getName());
        this.put("Signature.SHA384withRSA", MockSha384WithRsaSignature.class.getName());
        this.put("Signature.SHA512withRSA", MockSha512WithRsaSignature.class.getName());
        this.put("Signature.MD5withRSA", MockMd5WithRsaSignature.class.getName());
        this.put("Signature.SHA1withECDSA", MockSha1WithEcdsaSignature.class.getName());
        this.put("Signature.SHA256withECDSA", MockSha256WithEcdsaSignature.class.getName());
        this.put("Signature.SHA384withECDSA", MockSha384WithEcdsaSignature.class.getName());
        this.put("Signature.SHA512withECDSA", MockSha512WithEcdsaSignature.class.getName());
    }

    static PrivateKey wrapPrivateKey(PrivateKey realKey) {
        return new AlternativePrivateKeyWrapper(realKey);
    }

    static void resetSignatureOperationCount() {
        signatureOperations.set(0);
    }

    static int getSignatureOperationCount() {
        return signatureOperations.get();
    }

    public static final class MockSha512WithEcdsaSignature
    extends MockSignature {
        public MockSha512WithEcdsaSignature() throws NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA512withECDSA", "SunEC");
        }
    }

    public static final class MockSha384WithEcdsaSignature
    extends MockSignature {
        public MockSha384WithEcdsaSignature() throws NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA384withECDSA", "SunEC");
        }
    }

    public static final class MockSha256WithEcdsaSignature
    extends MockSignature {
        public MockSha256WithEcdsaSignature() throws NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA256withECDSA", "SunEC");
        }
    }

    public static final class MockSha1WithEcdsaSignature
    extends MockSignature {
        public MockSha1WithEcdsaSignature() throws NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA1withECDSA", "SunEC");
        }
    }

    public static final class MockMd5WithRsaSignature
    extends MockSignature {
        public MockMd5WithRsaSignature() throws NoSuchAlgorithmException, NoSuchProviderException {
            super("MD5withRSA", "SunRsaSign");
        }
    }

    public static final class MockSha512WithRsaSignature
    extends MockSignature {
        public MockSha512WithRsaSignature() throws NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA512withRSA", "SunRsaSign");
        }
    }

    public static final class MockSha384WithRsaSignature
    extends MockSignature {
        public MockSha384WithRsaSignature() throws NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA384withRSA", "SunRsaSign");
        }
    }

    public static final class MockSha256WithRsaSignature
    extends MockSignature {
        public MockSha256WithRsaSignature() throws NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA256withRSA", "SunRsaSign");
        }
    }

    public static final class MockSha1WithRsaSignature
    extends MockSignature {
        public MockSha1WithRsaSignature() throws NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA1withRSA", "SunRsaSign");
        }
    }

    public static final class MockRsaPssSignature
    extends MockSignature {
        public MockRsaPssSignature() throws NoSuchAlgorithmException, NoSuchProviderException {
            super("RSASSA-PSS", "SunRsaSign");
        }
    }

    public static abstract class MockSignature
    extends SignatureSpi {
        protected final String algorithm;
        protected final String providerName;
        protected final Signature realSignature;

        protected MockSignature(String algorithm, String providerName) throws NoSuchProviderException, NoSuchAlgorithmException {
            this.algorithm = algorithm;
            this.providerName = providerName;
            this.realSignature = Signature.getInstance(algorithm, providerName);
        }

        @Override
        protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
            try {
                this.realSignature.initVerify(publicKey);
            }
            catch (Exception e) {
                throw new InvalidKeyException("Failed to initialize signature", e);
            }
        }

        @Override
        protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
            this.engineInitSign(privateKey, null);
        }

        @Override
        protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
            try {
                if (!(privateKey instanceof AlternativePrivateKeyWrapper)) {
                    throw new InvalidKeyException("Unrecognized key type: " + privateKey.getClass().getName());
                }
                privateKey = ((AlternativePrivateKeyWrapper)privateKey).getDelegate();
                this.realSignature.initSign(privateKey, random);
            }
            catch (Exception e) {
                throw new InvalidKeyException("Failed to initialize signature", e);
            }
        }

        @Override
        protected void engineUpdate(byte b) throws SignatureException {
            this.realSignature.update(b);
        }

        @Override
        protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
            this.realSignature.update(b, off, len);
        }

        @Override
        protected byte[] engineSign() throws SignatureException {
            signatureOperations.incrementAndGet();
            return this.realSignature.sign();
        }

        @Override
        protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
            return this.realSignature.verify(sigBytes);
        }

        @Override
        protected void engineSetParameter(String param, Object value) {
            try {
                this.realSignature.setParameter(param, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            try {
                this.realSignature.setParameter(params);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InvalidAlgorithmParameterException("Failed to set parameter", e);
            }
        }

        @Override
        protected Object engineGetParameter(String param) {
            try {
                return this.realSignature.getParameter(param);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class AlternativePrivateKeyWrapper
    implements PrivateKey {
        private final PrivateKey delegate;

        AlternativePrivateKeyWrapper(PrivateKey delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getAlgorithm() {
            return this.delegate.getAlgorithm();
        }

        @Override
        public String getFormat() {
            return null;
        }

        @Override
        public byte[] getEncoded() {
            return null;
        }

        PrivateKey getDelegate() {
            return this.delegate;
        }
    }
}

