/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.MockAlternativeKeyProvider;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslAsyncPrivateKeyMethod;
import io.netty.handler.ssl.OpenSslContextOption;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslContextOption;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.pkitesting.CertificateBuilder;
import io.netty.pkitesting.X509Bundle;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.condition.EnabledIf;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;

@EnabledIf(value="isSignatureDelegationSupported")
@Timeout(value=30L)
public class JdkDelegatingPrivateKeyMethodTest {
    private static MockAlternativeKeyProvider mockProvider;
    private static EventLoopGroup GROUP;
    private static X509Bundle RSA_BUNDLE;

    @BeforeAll
    static void setUp() throws Exception {
        Assumptions.assumeTrue((boolean)OpenSsl.isAvailable(), (String)"OpenSSL is not available");
        mockProvider = new MockAlternativeKeyProvider();
        Security.addProvider(mockProvider);
        GROUP = new NioEventLoopGroup();
        RSA_BUNDLE = new CertificateBuilder().subject("CN=localhost, O=Netty, C=US").algorithm(CertificateBuilder.Algorithm.rsa2048).setIsCertificateAuthority(true).setKeyUsage(true, new CertificateBuilder.KeyUsage[]{CertificateBuilder.KeyUsage.digitalSignature}).addExtendedKeyUsageServerAuth().buildSelfSigned();
    }

    @AfterAll
    static void tearDown() {
        if (GROUP != null) {
            GROUP.shutdownGracefully();
        }
        if (mockProvider != null) {
            Security.removeProvider(mockProvider.getName());
        }
        RSA_BUNDLE = null;
    }

    static Stream<Arguments> supportedAlgorithms() {
        return Stream.of(true, false).flatMap(clientUsesProvider -> Stream.of(Arguments.of((Object[])new Object[]{"RSA PKCS#1 SHA1", OpenSslAsyncPrivateKeyMethod.SSL_SIGN_RSA_PKCS1_SHA1, CertificateBuilder.Algorithm.rsa2048, clientUsesProvider}), Arguments.of((Object[])new Object[]{"RSA PKCS#1 SHA256", OpenSslAsyncPrivateKeyMethod.SSL_SIGN_RSA_PKCS1_SHA256, CertificateBuilder.Algorithm.rsa2048, clientUsesProvider}), Arguments.of((Object[])new Object[]{"RSA PKCS#1 SHA384", OpenSslAsyncPrivateKeyMethod.SSL_SIGN_RSA_PKCS1_SHA384, CertificateBuilder.Algorithm.rsa2048, clientUsesProvider}), Arguments.of((Object[])new Object[]{"RSA PKCS#1 SHA512", OpenSslAsyncPrivateKeyMethod.SSL_SIGN_RSA_PKCS1_SHA512, CertificateBuilder.Algorithm.rsa2048, clientUsesProvider}), Arguments.of((Object[])new Object[]{"RSA PKCS#1 MD5+SHA1", OpenSslAsyncPrivateKeyMethod.SSL_SIGN_RSA_PKCS1_MD5_SHA1, CertificateBuilder.Algorithm.rsa2048, clientUsesProvider}), Arguments.of((Object[])new Object[]{"RSA-PSS SHA256", OpenSslAsyncPrivateKeyMethod.SSL_SIGN_RSA_PSS_RSAE_SHA256, CertificateBuilder.Algorithm.rsa2048, clientUsesProvider}), Arguments.of((Object[])new Object[]{"RSA-PSS SHA384", OpenSslAsyncPrivateKeyMethod.SSL_SIGN_RSA_PSS_RSAE_SHA384, CertificateBuilder.Algorithm.rsa2048, clientUsesProvider}), Arguments.of((Object[])new Object[]{"RSA-PSS SHA512", OpenSslAsyncPrivateKeyMethod.SSL_SIGN_RSA_PSS_RSAE_SHA512, CertificateBuilder.Algorithm.rsa2048, clientUsesProvider}), Arguments.of((Object[])new Object[]{"ECDSA SHA1 P-256", OpenSslAsyncPrivateKeyMethod.SSL_SIGN_ECDSA_SHA1, CertificateBuilder.Algorithm.ecp256, clientUsesProvider}), Arguments.of((Object[])new Object[]{"ECDSA SHA256 P-256", OpenSslAsyncPrivateKeyMethod.SSL_SIGN_ECDSA_SECP256R1_SHA256, CertificateBuilder.Algorithm.ecp256, clientUsesProvider}), Arguments.of((Object[])new Object[]{"ECDSA SHA384 P-384", OpenSslAsyncPrivateKeyMethod.SSL_SIGN_ECDSA_SECP384R1_SHA384, CertificateBuilder.Algorithm.ecp384, clientUsesProvider})));
    }

    @ParameterizedTest(name="{index}: scenario = {0}")
    @EnumSource(value=TestScenario.class)
    void testClientServerScenarios(TestScenario scenario) throws Exception {
        MockAlternativeKeyProvider.resetSignatureOperationCount();
        PrivateKey serverPrivateKey = scenario.serverUsesAlternativeKey ? MockAlternativeKeyProvider.wrapPrivateKey(RSA_BUNDLE.getKeyPair().getPrivate()) : RSA_BUNDLE.getKeyPair().getPrivate();
        X509Certificate serverCertificate = RSA_BUNDLE.getCertificate();
        PrivateKey clientPrivateKey = scenario.clientUsesAlternativeKey ? MockAlternativeKeyProvider.wrapPrivateKey(RSA_BUNDLE.getKeyPair().getPrivate()) : RSA_BUNDLE.getKeyPair().getPrivate();
        X509Certificate clientCertificate = RSA_BUNDLE.getCertificate();
        if (scenario.serverUsesAlternativeKey) {
            Assertions.assertNull((Object)serverPrivateKey.getEncoded(), (String)"Server alternative key should return null from getEncoded()");
        }
        if (scenario.clientUsesAlternativeKey) {
            Assertions.assertNull((Object)clientPrivateKey.getEncoded(), (String)"Client alternative key should return null from getEncoded()");
        }
        SslContext serverSslContext = SslContextBuilder.forServer((PrivateKey)serverPrivateKey, (X509Certificate[])new X509Certificate[]{serverCertificate}).sslProvider(SslProvider.OPENSSL).trustManager(new X509Certificate[]{clientCertificate}).option((SslContextOption)OpenSslContextOption.USE_JDK_PROVIDER_SIGNATURES, (Object)true).clientAuth(ClientAuth.REQUIRE).build();
        SslContext clientSslContext = SslContextBuilder.forClient().sslProvider(SslProvider.OPENSSL).trustManager(new X509Certificate[]{serverCertificate}).option((SslContextOption)OpenSslContextOption.USE_JDK_PROVIDER_SIGNATURES, (Object)true).keyManager(clientPrivateKey, new X509Certificate[]{clientCertificate}).build();
        String result = JdkDelegatingPrivateKeyMethodTest.performHandshakeTest(serverSslContext, clientSslContext);
        Assertions.assertEquals((Object)"R", (Object)result, (String)("Handshake should complete successfully for " + scenario.description));
        int expectedSignatureOperations = 0;
        if (scenario.serverUsesAlternativeKey) {
            ++expectedSignatureOperations;
        }
        if (scenario.clientUsesAlternativeKey) {
            ++expectedSignatureOperations;
        }
        int actualSignatureOperations = MockAlternativeKeyProvider.getSignatureOperationCount();
        Assertions.assertEquals((int)expectedSignatureOperations, (int)actualSignatureOperations, (String)("Unexpected number of signature operations for scenario: " + scenario.description));
        ReferenceCountUtil.release((Object)serverSslContext);
        ReferenceCountUtil.release((Object)clientSslContext);
    }

    @ParameterizedTest
    @MethodSource(value={"supportedAlgorithms"})
    void testAlgorithmSupport(String description, int opensslAlgorithm, CertificateBuilder.Algorithm algorithm, boolean clientUsesProvider) throws Exception {
        SslContextBuilder clientBuilder;
        SslContextBuilder serverBuilder;
        X509Bundle certKeyPair = JdkDelegatingPrivateKeyMethodTest.generateCertificateForAlgorithm(algorithm);
        PrivateKey wrappedKey = MockAlternativeKeyProvider.wrapPrivateKey(certKeyPair.getKeyPair().getPrivate());
        Assertions.assertNull((Object)wrappedKey.getEncoded(), (String)"Alternative key should return null from getEncoded()");
        MockAlternativeKeyProvider.resetSignatureOperationCount();
        if (clientUsesProvider) {
            serverBuilder = SslContextBuilder.forServer((PrivateKey)certKeyPair.getKeyPair().getPrivate(), (X509Certificate[])new X509Certificate[]{certKeyPair.getCertificate()}).sslProvider(SslProvider.OPENSSL).trustManager(new X509Certificate[]{certKeyPair.getCertificate()}).clientAuth(ClientAuth.REQUIRE);
            clientBuilder = SslContextBuilder.forClient().sslProvider(SslProvider.OPENSSL).option((SslContextOption)OpenSslContextOption.USE_JDK_PROVIDER_SIGNATURES, (Object)true).keyManager(wrappedKey, "", new X509Certificate[]{certKeyPair.getCertificate()}).trustManager(new X509Certificate[]{certKeyPair.getCertificate()});
        } else {
            serverBuilder = SslContextBuilder.forServer((PrivateKey)wrappedKey, (X509Certificate[])new X509Certificate[]{certKeyPair.getCertificate()}).sslProvider(SslProvider.OPENSSL).option((SslContextOption)OpenSslContextOption.USE_JDK_PROVIDER_SIGNATURES, (Object)true);
            clientBuilder = SslContextBuilder.forClient().sslProvider(SslProvider.OPENSSL).trustManager(new X509Certificate[]{certKeyPair.getCertificate()});
        }
        JdkDelegatingPrivateKeyMethodTest.configureCipherSuitesForAlgorithm(serverBuilder, clientBuilder, opensslAlgorithm);
        SslContext serverContext = serverBuilder.build();
        SslContext clientContext = clientBuilder.build();
        String result = JdkDelegatingPrivateKeyMethodTest.performHandshakeTest(serverContext, clientContext);
        Assertions.assertEquals((Object)"R", (Object)result, (String)("Handshake should complete successfully for " + description));
        int signatureOperations = MockAlternativeKeyProvider.getSignatureOperationCount();
        Assertions.assertTrue((signatureOperations > 0 ? 1 : 0) != 0, (String)("Expected signature operations to be recorded for " + description + ", got: " + signatureOperations));
        ReferenceCountUtil.release((Object)serverContext);
        ReferenceCountUtil.release((Object)clientContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testMultipleHandshakes() throws Exception {
        PrivateKey wrappedPrivateKey = MockAlternativeKeyProvider.wrapPrivateKey(RSA_BUNDLE.getKeyPair().getPrivate());
        X509Certificate certificate = RSA_BUNDLE.getCertificate();
        final SslContext serverSslContext = SslContextBuilder.forServer((PrivateKey)wrappedPrivateKey, (X509Certificate[])new X509Certificate[]{certificate}).sslProvider(SslProvider.OPENSSL).option((SslContextOption)OpenSslContextOption.USE_JDK_PROVIDER_SIGNATURES, (Object)true).build();
        SslContext clientSslContext = SslContextBuilder.forClient().sslProvider(SslProvider.OPENSSL).trustManager(new X509Certificate[]{certificate}).build();
        int numberOfConnections = 3;
        ArrayList<Future<String>> results = new ArrayList<Future<String>>();
        ServerBootstrap serverBootstrap = ((ServerBootstrap)new ServerBootstrap().group(GROUP).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                SslHandler sslHandler = serverSslContext.newHandler(ch.alloc());
                pipeline.addLast(new ChannelHandler[]{sslHandler});
                pipeline.addLast(new ChannelHandler[]{ServerHandler.INSTANCE});
            }
        });
        ChannelFuture serverChannelFuture = serverBootstrap.bind(0).sync();
        Channel serverChannel = serverChannelFuture.channel();
        int serverPort = ((InetSocketAddress)serverChannel.localAddress()).getPort();
        try {
            for (int i = 0; i < numberOfConnections; ++i) {
                results.add(JdkDelegatingPrivateKeyMethodTest.runClient(serverPort, clientSslContext));
            }
            for (Future future : results) {
                Assertions.assertEquals((Object)"R", (Object)future.get(20L, TimeUnit.SECONDS), (String)"All connections should complete within timeout");
            }
        }
        finally {
            serverChannel.close().sync();
            ReferenceCountUtil.release((Object)serverSslContext);
            ReferenceCountUtil.release((Object)clientSslContext);
        }
    }

    @Test
    void testAlgorithmCaching() throws Exception {
        PrivateKey alternativeKey = MockAlternativeKeyProvider.wrapPrivateKey(RSA_BUNDLE.getKeyPair().getPrivate());
        MockAlternativeKeyProvider.resetSignatureOperationCount();
        SslContext context1 = SslContextBuilder.forServer((PrivateKey)alternativeKey, (X509Certificate[])new X509Certificate[]{RSA_BUNDLE.getCertificate()}).sslProvider(SslProvider.OPENSSL).option((SslContextOption)OpenSslContextOption.USE_JDK_PROVIDER_SIGNATURES, (Object)true).build();
        SslContext context2 = SslContextBuilder.forServer((PrivateKey)alternativeKey, (X509Certificate[])new X509Certificate[]{RSA_BUNDLE.getCertificate()}).sslProvider(SslProvider.OPENSSL).option((SslContextOption)OpenSslContextOption.USE_JDK_PROVIDER_SIGNATURES, (Object)true).build();
        Assertions.assertNotNull((Object)context1, (String)"First context should be created");
        Assertions.assertNotNull((Object)context2, (String)"Second context should be created");
        ReferenceCountUtil.release((Object)context1);
        ReferenceCountUtil.release((Object)context2);
    }

    private static void configureCipherSuitesForAlgorithm(SslContextBuilder serverBuilder, SslContextBuilder clientBuilder, int opensslAlgorithm) {
        String cipherSuite;
        String protocol = null;
        if (opensslAlgorithm == OpenSslAsyncPrivateKeyMethod.SSL_SIGN_RSA_PSS_RSAE_SHA256) {
            cipherSuite = "TLS_AES_128_GCM_SHA256";
            protocol = "TLSv1.3";
        } else if (opensslAlgorithm == OpenSslAsyncPrivateKeyMethod.SSL_SIGN_RSA_PSS_RSAE_SHA384) {
            cipherSuite = "TLS_AES_256_GCM_SHA384";
            protocol = "TLSv1.3";
        } else if (opensslAlgorithm == OpenSslAsyncPrivateKeyMethod.SSL_SIGN_RSA_PSS_RSAE_SHA512) {
            cipherSuite = "TLS_AES_256_GCM_SHA384";
            protocol = "TLSv1.3";
        } else if (opensslAlgorithm == OpenSslAsyncPrivateKeyMethod.SSL_SIGN_ECDSA_SHA1) {
            cipherSuite = "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA";
        } else if (opensslAlgorithm == OpenSslAsyncPrivateKeyMethod.SSL_SIGN_ECDSA_SECP256R1_SHA256) {
            cipherSuite = "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256";
        } else if (opensslAlgorithm == OpenSslAsyncPrivateKeyMethod.SSL_SIGN_ECDSA_SECP384R1_SHA384) {
            cipherSuite = "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384";
        } else if (opensslAlgorithm == OpenSslAsyncPrivateKeyMethod.SSL_SIGN_ECDSA_SECP521R1_SHA512) {
            cipherSuite = "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384";
        } else if (opensslAlgorithm == OpenSslAsyncPrivateKeyMethod.SSL_SIGN_RSA_PKCS1_SHA1) {
            cipherSuite = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA";
        } else if (opensslAlgorithm == OpenSslAsyncPrivateKeyMethod.SSL_SIGN_RSA_PKCS1_SHA256) {
            cipherSuite = "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256";
        } else if (opensslAlgorithm == OpenSslAsyncPrivateKeyMethod.SSL_SIGN_RSA_PKCS1_SHA384) {
            cipherSuite = "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384";
        } else if (opensslAlgorithm == OpenSslAsyncPrivateKeyMethod.SSL_SIGN_RSA_PKCS1_SHA512) {
            cipherSuite = "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384";
        } else if (opensslAlgorithm == OpenSslAsyncPrivateKeyMethod.SSL_SIGN_RSA_PKCS1_MD5_SHA1) {
            cipherSuite = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA";
        } else {
            throw new IllegalArgumentException("Unsupported OpenSSL algorithm: " + opensslAlgorithm);
        }
        List<String> singleCipherSuite = Arrays.asList(cipherSuite);
        serverBuilder.ciphers(singleCipherSuite);
        clientBuilder.ciphers(singleCipherSuite);
        if (protocol != null) {
            serverBuilder.protocols(new String[]{protocol});
            clientBuilder.protocols(new String[]{protocol});
        }
    }

    private static X509Bundle generateCertificateForAlgorithm(CertificateBuilder.Algorithm algorithm) throws Exception {
        CertificateBuilder builder = new CertificateBuilder().subject("CN=localhost, O=Netty, C=US").setIsCertificateAuthority(true).setKeyUsage(true, new CertificateBuilder.KeyUsage[]{CertificateBuilder.KeyUsage.digitalSignature}).addExtendedKeyUsageServerAuth().algorithm(algorithm);
        return builder.buildSelfSigned();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String performHandshakeTest(final SslContext serverContext, SslContext clientContext) throws Exception {
        ServerBootstrap serverBootstrap = ((ServerBootstrap)new ServerBootstrap().group(GROUP).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                SslHandler serverSslHandler = serverContext.newHandler(ch.alloc());
                pipeline.addLast(new ChannelHandler[]{serverSslHandler});
                pipeline.addLast(new ChannelHandler[]{ServerHandler.INSTANCE});
            }
        });
        ChannelFuture serverChannelFuture = serverBootstrap.bind(0).sync();
        Channel serverChannel = serverChannelFuture.channel();
        int serverPort = ((InetSocketAddress)serverChannel.localAddress()).getPort();
        try {
            String string = (String)JdkDelegatingPrivateKeyMethodTest.runClient(serverPort, clientContext).get(10L, TimeUnit.SECONDS);
            return string;
        }
        finally {
            serverChannel.close().sync();
        }
    }

    private static Future<String> runClient(final int serverPort, final SslContext clientSslContext) {
        final Promise resultPromise = GROUP.next().newPromise();
        Bootstrap clientBootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(GROUP)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                SslHandler sslHandler = clientSslContext.newHandler(ch.alloc(), "localhost", serverPort);
                pipeline.addLast(new ChannelHandler[]{sslHandler});
                pipeline.addLast(new ChannelHandler[]{new ClientHandler((Promise<String>)resultPromise)});
            }
        });
        clientBootstrap.connect("localhost", serverPort).addListener(future -> {
            if (!future.isSuccess()) {
                resultPromise.tryFailure(future.cause());
            }
        });
        return resultPromise;
    }

    private static boolean isSignatureDelegationSupported() {
        return OpenSsl.isBoringSSL() || OpenSsl.isAWSLC();
    }

    @ChannelHandler.Sharable
    private static final class ServerHandler
    extends ChannelInboundHandlerAdapter {
        static final ChannelInboundHandler INSTANCE = new ServerHandler();

        private ServerHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            ctx.writeAndFlush(msg).addListener(future -> ctx.close());
        }
    }

    private static final class ClientHandler
    extends ChannelInboundHandlerAdapter {
        final Promise<String> resultPromise;

        ClientHandler(Promise<String> resultPromise) {
            this.resultPromise = resultPromise;
        }

        public void channelActive(ChannelHandlerContext ctx) {
            ByteBuf message = Unpooled.copiedBuffer((CharSequence)"R", (Charset)CharsetUtil.UTF_8);
            ctx.writeAndFlush((Object)message);
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (msg instanceof ByteBuf) {
                ByteBuf bytes = (ByteBuf)msg;
                this.resultPromise.setSuccess((Object)bytes.toString(CharsetUtil.UTF_8));
                bytes.release();
                ctx.close();
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            this.resultPromise.tryFailure(cause);
            ctx.close();
        }
    }

    public static enum TestScenario {
        SERVER_ALTERNATIVE_CLIENT_STANDARD("Server Alternative + Client Standard", true, false),
        SERVER_STANDARD_CLIENT_ALTERNATIVE("Server Standard + Client Alternative", false, true),
        BOTH_ALTERNATIVE("Both Alternative", true, true);

        final String description;
        final boolean serverUsesAlternativeKey;
        final boolean clientUsesAlternativeKey;

        private TestScenario(String description, boolean serverUsesAlternativeKey, boolean clientUsesAlternativeKey) {
            this.description = description;
            this.serverUsesAlternativeKey = serverUsesAlternativeKey;
            this.clientUsesAlternativeKey = clientUsesAlternativeKey;
        }

        public String toString() {
            return this.description;
        }
    }
}

