/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.OpenSslErrorStackAssertSSLEngine;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.SslContextTest;
import java.io.InputStream;
import java.security.Provider;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.conscrypt.OpenSSLProvider;
import org.junit.jupiter.api.Assertions;

public final class Java8SslTestUtils {
    private Java8SslTestUtils() {
    }

    static void setSNIMatcher(SSLParameters parameters, final byte[] match) {
        SNIMatcher matcher = new SNIMatcher(0){

            @Override
            public boolean matches(SNIServerName sniServerName) {
                return Arrays.equals(match, sniServerName.getEncoded());
            }
        };
        parameters.setSNIMatchers(Collections.singleton(matcher));
    }

    static Provider conscryptProvider() {
        return new OpenSSLProvider();
    }

    static SSLEngine wrapSSLEngineForTesting(SSLEngine engine) {
        if (engine instanceof ReferenceCountedOpenSslEngine) {
            return new OpenSslErrorStackAssertSSLEngine((ReferenceCountedOpenSslEngine)engine);
        }
        return engine;
    }

    public static X509Certificate[] loadCertCollection(String ... resourceNames) throws Exception {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        X509Certificate[] certCollection = new X509Certificate[resourceNames.length];
        for (int i = 0; i < resourceNames.length; ++i) {
            String resourceName = resourceNames[i];
            try (InputStream is = SslContextTest.class.getResourceAsStream(resourceName);){
                Assertions.assertNotNull((Object)is, (String)("Cannot find " + resourceName));
                certCollection[i] = (X509Certificate)certFactory.generateCertificate(is);
                continue;
            }
        }
        return certCollection;
    }
}

