/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IdentityCipherSuiteFilterTest {
    @Test
    public void regularInstanceDefaultsToDefaultCiphers() {
        List<String> defaultCiphers = Arrays.asList("FOO", "BAR");
        HashSet<String> supportedCiphers = new HashSet<String>(Arrays.asList("BAZ", "QIX"));
        Object[] filtered = IdentityCipherSuiteFilter.INSTANCE.filterCipherSuites(null, defaultCiphers, supportedCiphers);
        Assertions.assertArrayEquals((Object[])defaultCiphers.toArray(), (Object[])filtered);
    }

    @Test
    public void alternativeInstanceDefaultsToSupportedCiphers() {
        List<String> defaultCiphers = Arrays.asList("FOO", "BAR");
        HashSet<String> supportedCiphers = new HashSet<String>(Arrays.asList("BAZ", "QIX"));
        Object[] filtered = IdentityCipherSuiteFilter.INSTANCE_DEFAULTING_TO_SUPPORTED_CIPHERS.filterCipherSuites(null, defaultCiphers, supportedCiphers);
        Assertions.assertArrayEquals((Object[])supportedCiphers.toArray(), (Object[])filtered);
    }
}

