/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.BouncyCastleAlpnSslEngine;
import io.netty.handler.ssl.BouncyCastleAlpnSslUtils;
import io.netty.handler.ssl.JdkAlpnApplicationProtocolNegotiator;
import io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import io.netty.handler.ssl.SslUtils;
import io.netty.handler.ssl.util.BouncyCastleUtil;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.List;
import java.util.function.BiFunction;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BouncyCastleEngineAlpnTest {
    @Test
    public void testBouncyCastleSSLEngineSupportsAlpn() throws Exception {
        BouncyCastleJsseProvider bouncyCastleProvider = new BouncyCastleJsseProvider();
        SSLContext context = SslUtils.getSSLContext((Provider)bouncyCastleProvider, (SecureRandom)new SecureRandom());
        SSLEngine engine = context.createSSLEngine();
        Assertions.assertTrue((boolean)BouncyCastleUtil.isBcJsseInUse((SSLEngine)engine));
        Assertions.assertTrue((boolean)BouncyCastleAlpnSslUtils.isAlpnSupported());
        BouncyCastleAlpnSslEngine alpnSslEngine = new BouncyCastleAlpnSslEngine(engine, (JdkApplicationProtocolNegotiator)new JdkAlpnApplicationProtocolNegotiator(new String[]{"fake"}), true);
        alpnSslEngine.setHandshakeApplicationProtocolSelector((BiFunction)new BiFunction<SSLEngine, List<String>, String>(){

            @Override
            public String apply(SSLEngine sslEngine, List<String> strings) {
                return "fake";
            }
        });
        alpnSslEngine.getHandshakeApplicationProtocolSelector();
        alpnSslEngine.setNegotiatedApplicationProtocol("fake");
        alpnSslEngine.getNegotiatedApplicationProtocol();
    }
}

