/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.util.CharsetUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class SslContextBuilderTest {
    @Test
    public void testClientContextFromFileJdk() throws Exception {
        SslContextBuilderTest.testClientContextFromFile(SslProvider.JDK);
    }

    @Test
    public void testClientContextFromFileOpenssl() throws Exception {
        Assume.assumeTrue((boolean)OpenSsl.isAvailable());
        SslContextBuilderTest.testClientContextFromFile(SslProvider.OPENSSL);
    }

    @Test
    public void testClientContextJdk() throws Exception {
        SslContextBuilderTest.testClientContext(SslProvider.JDK);
    }

    @Test
    public void testClientContextOpenssl() throws Exception {
        Assume.assumeTrue((boolean)OpenSsl.isAvailable());
        SslContextBuilderTest.testClientContext(SslProvider.OPENSSL);
    }

    @Test
    public void testKeyStoreTypeJdk() throws Exception {
        SslContextBuilderTest.testKeyStoreType(SslProvider.JDK);
    }

    @Test
    public void testKeyStoreTypeOpenssl() throws Exception {
        Assume.assumeTrue((boolean)OpenSsl.isAvailable());
        SslContextBuilderTest.testKeyStoreType(SslProvider.OPENSSL);
    }

    @Test
    public void testServerContextFromFileJdk() throws Exception {
        SslContextBuilderTest.testServerContextFromFile(SslProvider.JDK);
    }

    @Test
    public void testServerContextFromFileOpenssl() throws Exception {
        Assume.assumeTrue((boolean)OpenSsl.isAvailable());
        SslContextBuilderTest.testServerContextFromFile(SslProvider.OPENSSL);
    }

    @Test
    public void testServerContextJdk() throws Exception {
        SslContextBuilderTest.testServerContext(SslProvider.JDK);
    }

    @Test
    public void testServerContextOpenssl() throws Exception {
        Assume.assumeTrue((boolean)OpenSsl.isAvailable());
        SslContextBuilderTest.testServerContext(SslProvider.OPENSSL);
    }

    @Test
    public void testContextFromManagersJdk() throws Exception {
        SslContextBuilderTest.testContextFromManagers(SslProvider.JDK);
    }

    @Test
    public void testContextFromManagersOpenssl() throws Exception {
        Assume.assumeTrue((boolean)OpenSsl.isAvailable());
        SslContextBuilderTest.testContextFromManagers(SslProvider.OPENSSL);
    }

    @Test(expected=SSLException.class)
    public void testUnsupportedPrivateKeyFailsFastForServer() throws Exception {
        Assume.assumeTrue((boolean)OpenSsl.isBoringSSL());
        SslContextBuilderTest.testUnsupportedPrivateKeyFailsFast(true);
    }

    @Test(expected=SSLException.class)
    public void testUnsupportedPrivateKeyFailsFastForClient() throws Exception {
        Assume.assumeTrue((boolean)OpenSsl.isBoringSSL());
        SslContextBuilderTest.testUnsupportedPrivateKeyFailsFast(false);
    }

    private static void testUnsupportedPrivateKeyFailsFast(boolean server) throws Exception {
        Assume.assumeTrue((boolean)OpenSsl.isBoringSSL());
        String cert = "-----BEGIN CERTIFICATE-----\nMIICODCCAY2gAwIBAgIEXKTrajAKBggqhkjOPQQDBDBUMQswCQYDVQQGEwJVUzEM\nMAoGA1UECAwDTi9hMQwwCgYDVQQHDANOL2ExDDAKBgNVBAoMA04vYTEMMAoGA1UE\nCwwDTi9hMQ0wCwYDVQQDDARUZXN0MB4XDTE5MDQwMzE3MjA0MloXDTIwMDQwMjE3\nMjA0MlowVDELMAkGA1UEBhMCVVMxDDAKBgNVBAgMA04vYTEMMAoGA1UEBwwDTi9h\nMQwwCgYDVQQKDANOL2ExDDAKBgNVBAsMA04vYTENMAsGA1UEAwwEVGVzdDCBpzAQ\nBgcqhkjOPQIBBgUrgQQAJwOBkgAEBPYWoTjlS2pCMGEM2P8qZnmURWA5e7XxPfIh\nHA876sjmgjJluPgT0OkweuxI4Y/XjzcPnnEBONgzAV1X93UmXdtRiIau/zvsAeFb\nj/q+6sfj1jdnUk6QsMx22kAwplXHmdz1z5ShXQ7mDZPxDbhCPEAUXzIzOqvWIZyA\nHgFxZXmQKEhExA8nxgSIvzQ3ucMwMAoGCCqGSM49BAMEA4GYADCBlAJIAdPD6jaN\nvGxkxcsIbcHn2gSfP1F1G8iNJYrXIN91KbQm8OEp4wxqnBwX8gb/3rmSoEhIU/te\nCcHuFs0guBjfgRWtJ/eDnKB/AkgDbkqrB5wqJFBmVd/rJ5QdwUVNuGP/vDjFVlb6\nEsny6//gTL7jYubLUKHOPIMftCZ2Jn4b+5l0kAs62HD5XkZLPDTwRbf7VCE=\n-----END CERTIFICATE-----";
        String key = "-----BEGIN PRIVATE KEY-----\nMIIBCQIBADAQBgcqhkjOPQIBBgUrgQQAJwSB8TCB7gIBAQRIALNClTXqQWWlYDHw\nLjNxXpLk17iPepkmablhbxmYX/8CNzoz1o2gcUidoIO2DM9hm7adI/W31EOmSiUJ\n+UsC/ZH3i2qr0wn+oAcGBSuBBAAnoYGVA4GSAAQE9hahOOVLakIwYQzY/ypmeZRF\nYDl7tfE98iEcDzvqyOaCMmW4+BPQ6TB67Ejhj9ePNw+ecQE42DMBXVf3dSZd21GI\nhq7/O+wB4VuP+r7qx+PWN2dSTpCwzHbaQDCmVceZ3PXPlKFdDuYNk/ENuEI8QBRf\nMjM6q9YhnIAeAXFleZAoSETEDyfGBIi/NDe5wzA=\n-----END PRIVATE KEY-----";
        if (server) {
            SslContextBuilder.forServer((InputStream)new ByteArrayInputStream(cert.getBytes(CharsetUtil.US_ASCII)), (InputStream)new ByteArrayInputStream(key.getBytes(CharsetUtil.US_ASCII)), null).sslProvider(SslProvider.OPENSSL).build();
        } else {
            SslContextBuilder.forClient().keyManager((InputStream)new ByteArrayInputStream(cert.getBytes(CharsetUtil.US_ASCII)), (InputStream)new ByteArrayInputStream(key.getBytes(CharsetUtil.US_ASCII)), null).sslProvider(SslProvider.OPENSSL).build();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidCipherJdk() throws Exception {
        Assume.assumeTrue((boolean)OpenSsl.isAvailable());
        SslContextBuilderTest.testInvalidCipher(SslProvider.JDK);
    }

    @Test
    public void testInvalidCipherOpenSSL() throws Exception {
        Assume.assumeTrue((boolean)OpenSsl.isAvailable());
        try {
            SslContextBuilderTest.testInvalidCipher(SslProvider.OPENSSL);
            if (!OpenSsl.versionString().contains("1.1.1")) {
                Assert.fail();
            }
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
    }

    private static void testKeyStoreType(SslProvider provider) throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        SslContextBuilder builder = SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslProvider(provider).keyStoreType("PKCS12");
        SslContext context = builder.build();
        SSLEngine engine = context.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        engine.closeInbound();
        engine.closeOutbound();
    }

    private static void testInvalidCipher(SslProvider provider) throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        SslContextBuilder builder = SslContextBuilder.forClient().sslProvider(provider).ciphers(Collections.singleton("SOME_INVALID_CIPHER")).keyManager(cert.certificate(), cert.privateKey()).trustManager(cert.certificate());
        SslContext context = builder.build();
        context.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
    }

    private static void testClientContextFromFile(SslProvider provider) throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        SslContextBuilder builder = SslContextBuilder.forClient().sslProvider(provider).keyManager(cert.certificate(), cert.privateKey()).trustManager(cert.certificate()).clientAuth(ClientAuth.OPTIONAL);
        SslContext context = builder.build();
        SSLEngine engine = context.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assert.assertFalse((boolean)engine.getWantClientAuth());
        Assert.assertFalse((boolean)engine.getNeedClientAuth());
        engine.closeInbound();
        engine.closeOutbound();
    }

    private static void testClientContext(SslProvider provider) throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        SslContextBuilder builder = SslContextBuilder.forClient().sslProvider(provider).keyManager(cert.key(), new X509Certificate[]{cert.cert()}).trustManager(new X509Certificate[]{cert.cert()}).clientAuth(ClientAuth.OPTIONAL);
        SslContext context = builder.build();
        SSLEngine engine = context.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assert.assertFalse((boolean)engine.getWantClientAuth());
        Assert.assertFalse((boolean)engine.getNeedClientAuth());
        engine.closeInbound();
        engine.closeOutbound();
    }

    private static void testServerContextFromFile(SslProvider provider) throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        SslContextBuilder builder = SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslProvider(provider).trustManager(cert.certificate()).clientAuth(ClientAuth.OPTIONAL);
        SslContext context = builder.build();
        SSLEngine engine = context.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assert.assertTrue((boolean)engine.getWantClientAuth());
        Assert.assertFalse((boolean)engine.getNeedClientAuth());
        engine.closeInbound();
        engine.closeOutbound();
    }

    private static void testServerContext(SslProvider provider) throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        SslContextBuilder builder = SslContextBuilder.forServer((PrivateKey)cert.key(), (X509Certificate[])new X509Certificate[]{cert.cert()}).sslProvider(provider).trustManager(new X509Certificate[]{cert.cert()}).clientAuth(ClientAuth.REQUIRE);
        SslContext context = builder.build();
        SSLEngine engine = context.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assert.assertFalse((boolean)engine.getWantClientAuth());
        Assert.assertTrue((boolean)engine.getNeedClientAuth());
        engine.closeInbound();
        engine.closeOutbound();
    }

    private static void testContextFromManagers(SslProvider provider) throws Exception {
        final SelfSignedCertificate cert = new SelfSignedCertificate();
        X509ExtendedKeyManager customKeyManager = new X509ExtendedKeyManager(){

            @Override
            public String[] getClientAliases(String s, Principal[] principals) {
                return new String[0];
            }

            @Override
            public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
                return "cert_sent_to_server";
            }

            @Override
            public String[] getServerAliases(String s, Principal[] principals) {
                return new String[0];
            }

            @Override
            public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
                return null;
            }

            @Override
            public X509Certificate[] getCertificateChain(String s) {
                X509Certificate[] certificates = new X509Certificate[]{cert.cert()};
                return new X509Certificate[0];
            }

            @Override
            public PrivateKey getPrivateKey(String s) {
                return cert.key();
            }
        };
        X509ExtendedTrustManager customTrustManager = new X509ExtendedTrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        SslContextBuilder client_builder = SslContextBuilder.forClient().sslProvider(provider).keyManager((KeyManager)customKeyManager).trustManager((TrustManager)customTrustManager).clientAuth(ClientAuth.OPTIONAL);
        SslContext client_context = client_builder.build();
        SSLEngine client_engine = client_context.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assert.assertFalse((boolean)client_engine.getWantClientAuth());
        Assert.assertFalse((boolean)client_engine.getNeedClientAuth());
        client_engine.closeInbound();
        client_engine.closeOutbound();
        SslContextBuilder server_builder = SslContextBuilder.forServer((KeyManager)customKeyManager).sslProvider(provider).trustManager((TrustManager)customTrustManager).clientAuth(ClientAuth.REQUIRE);
        SslContext server_context = server_builder.build();
        SSLEngine server_engine = server_context.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assert.assertFalse((boolean)server_engine.getWantClientAuth());
        Assert.assertTrue((boolean)server_engine.getNeedClientAuth());
        server_engine.closeInbound();
        server_engine.closeOutbound();
    }
}

