/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslCertificateException;
import io.netty.internal.tcnative.CertificateVerifier;
import java.lang.reflect.Field;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class OpenSslCertificateExceptionTest {
    @Test
    public void testValidErrorCode() throws Exception {
        Field[] fields;
        Assume.assumeTrue((boolean)OpenSsl.isAvailable());
        for (Field field : fields = CertificateVerifier.class.getFields()) {
            if (!field.isAccessible()) continue;
            int errorCode = field.getInt(null);
            OpenSslCertificateException exception = new OpenSslCertificateException(errorCode);
            Assert.assertEquals((long)errorCode, (long)exception.errorCode());
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNonValidErrorCode() {
        Assume.assumeTrue((boolean)OpenSsl.isAvailable());
        new OpenSslCertificateException(Integer.MIN_VALUE);
    }

    @Test
    public void testCanBeInstancedWhenOpenSslIsNotAvailable() {
        Assume.assumeFalse((boolean)OpenSsl.isAvailable());
        new OpenSslCertificateException(0);
    }
}

