/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.ssl.OpenSslCachingKeyMaterialProvider;
import io.netty.handler.ssl.OpenSslCachingX509KeyManagerFactory;
import io.netty.handler.ssl.OpenSslKeyMaterial;
import io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import io.netty.handler.ssl.OpenSslKeyMaterialProviderTest;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class OpenSslCachingKeyMaterialProviderTest
extends OpenSslKeyMaterialProviderTest {
    @Override
    protected KeyManagerFactory newKeyManagerFactory() throws Exception {
        return new OpenSslCachingX509KeyManagerFactory(super.newKeyManagerFactory());
    }

    @Override
    protected OpenSslKeyMaterialProvider newMaterialProvider(KeyManagerFactory factory, String password) {
        return new OpenSslCachingKeyMaterialProvider(ReferenceCountedOpenSslContext.chooseX509KeyManager((KeyManager[])factory.getKeyManagers()), password, Integer.MAX_VALUE);
    }

    @Override
    protected void assertRelease(OpenSslKeyMaterial material) {
        Assert.assertFalse((boolean)material.release());
    }

    @Test
    public void testMaterialCached() throws Exception {
        OpenSslKeyMaterialProvider provider = this.newMaterialProvider(this.newKeyManagerFactory(), "example");
        OpenSslKeyMaterial material = provider.chooseKeyMaterial((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, "1");
        Assert.assertNotNull((Object)material);
        Assert.assertNotEquals((long)0L, (long)material.certificateChainAddress());
        Assert.assertNotEquals((long)0L, (long)material.privateKeyAddress());
        Assert.assertEquals((long)2L, (long)material.refCnt());
        OpenSslKeyMaterial material2 = provider.chooseKeyMaterial((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, "1");
        Assert.assertNotNull((Object)material2);
        Assert.assertEquals((long)material.certificateChainAddress(), (long)material2.certificateChainAddress());
        Assert.assertEquals((long)material.privateKeyAddress(), (long)material2.privateKeyAddress());
        Assert.assertEquals((long)3L, (long)material.refCnt());
        Assert.assertEquals((long)3L, (long)material2.refCnt());
        Assert.assertFalse((boolean)material.release());
        Assert.assertFalse((boolean)material2.release());
        provider.destroy();
        Assert.assertEquals((long)0L, (long)material.refCnt());
        Assert.assertEquals((long)0L, (long)material2.refCnt());
    }

    @Test
    public void testCacheForSunX509() throws Exception {
        OpenSslCachingX509KeyManagerFactory factory = new OpenSslCachingX509KeyManagerFactory(super.newKeyManagerFactory("SunX509"));
        OpenSslKeyMaterialProvider provider = factory.newProvider("example");
        Assert.assertThat((Object)provider, (Matcher)CoreMatchers.instanceOf(OpenSslCachingKeyMaterialProvider.class));
    }

    @Test
    public void testNotCacheForX509() throws Exception {
        OpenSslCachingX509KeyManagerFactory factory = new OpenSslCachingX509KeyManagerFactory(super.newKeyManagerFactory("PKIX"));
        OpenSslKeyMaterialProvider provider = factory.newProvider("example");
        Assert.assertThat((Object)provider, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(OpenSslCachingKeyMaterialProvider.class)));
    }
}

