/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.logging;

import io.netty.util.internal.logging.AbstractInternalLoggerTest;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.Log4J2Logger;
import java.util.EnumMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.junit.jupiter.api.Assertions;

public class Log4J2LoggerTest
extends AbstractInternalLoggerTest<Logger> {
    private static final EnumMap<InternalLogLevel, Level> DISABLING_LEVEL = new EnumMap(InternalLogLevel.class);

    public Log4J2LoggerTest() {
        this.mockLog = LogManager.getLogger((String)this.loggerName);
        this.logger = new Log4J2Logger((Logger)this.mockLog){
            private static final long serialVersionUID = 1L;

            public void logMessage(String fqcn, Level level, Marker marker, Message message, Throwable t) {
                Log4J2LoggerTest.this.result.put("level", level.name());
                Log4J2LoggerTest.this.result.put("t", t);
                super.logMessage(fqcn, level, marker, message, t);
            }
        };
    }

    @Override
    protected void setLevelEnable(InternalLogLevel level, boolean enable) {
        Level targetLevel = Level.valueOf((String)level.name());
        if (!enable) {
            targetLevel = DISABLING_LEVEL.get(level);
        }
        ((org.apache.logging.log4j.core.Logger)this.mockLog).setLevel(targetLevel);
    }

    @Override
    protected void assertResult(InternalLogLevel level, String format, Throwable t, Object ... args) {
        super.assertResult(level, format, t, args);
        Assertions.assertEquals((Object)t, this.result.get("t"));
        Assertions.assertEquals((Object)level.name(), this.result.get("level"));
    }

    static {
        DISABLING_LEVEL.put(InternalLogLevel.TRACE, Level.DEBUG);
        DISABLING_LEVEL.put(InternalLogLevel.DEBUG, Level.INFO);
        DISABLING_LEVEL.put(InternalLogLevel.INFO, Level.WARN);
        DISABLING_LEVEL.put(InternalLogLevel.WARN, Level.ERROR);
        DISABLING_LEVEL.put(InternalLogLevel.ERROR, Level.FATAL);
    }
}

