/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.PlatformDependent0;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public class VirtualThreadCheckTest {
    @Test
    public void testCheckVirtualThread() throws Exception {
        Assertions.assertFalse((boolean)PlatformDependent.isVirtualThread(null));
        Assertions.assertFalse((boolean)PlatformDependent.isVirtualThread((Thread)Thread.currentThread()));
        FastThreadLocalThread fastThreadLocalThread = new FastThreadLocalThread();
        Assertions.assertFalse((boolean)PlatformDependent.isVirtualThread((Thread)fastThreadLocalThread));
        final AtomicReference atomicRes = new AtomicReference();
        Thread subThread = new Thread(){

            @Override
            public void run() {
                atomicRes.set(PlatformDependent.isVirtualThread((Thread)Thread.currentThread()));
            }
        };
        subThread.start();
        subThread.join();
        Assertions.assertFalse((boolean)((Boolean)atomicRes.get()));
        SubThread subOfSubThread = new SubThread(){

            @Override
            public void run() {
                atomicRes.set(PlatformDependent.isVirtualThread((Thread)Thread.currentThread()));
            }
        };
        subOfSubThread.start();
        subOfSubThread.join();
        Assertions.assertFalse((boolean)((Boolean)atomicRes.get()));
        SubOfSubThread subOfSubOfSubThread = new SubOfSubThread(){

            @Override
            public void run() {
                atomicRes.set(PlatformDependent.isVirtualThread((Thread)Thread.currentThread()));
            }
        };
        subOfSubOfSubThread.start();
        subOfSubOfSubThread.join();
        Assertions.assertFalse((boolean)((Boolean)atomicRes.get()));
        Assumptions.assumeTrue((PlatformDependent.javaVersion() >= 21 ? 1 : 0) != 0);
        Method startVirtualThread = this.getStartVirtualThreadMethod();
        Thread virtualThread = (Thread)startVirtualThread.invoke(null, new Runnable(){

            @Override
            public void run() {
            }
        });
        Assertions.assertTrue((boolean)PlatformDependent.isVirtualThread((Thread)virtualThread));
    }

    @Test
    public void testGetVirtualThreadCheckMethod() throws Throwable {
        if (PlatformDependent.javaVersion() < 19) {
            Assertions.assertNull((Object)PlatformDependent0.IS_VIRTUAL_THREAD_METHOD_HANDLE);
        } else {
            Assumptions.assumeTrue((PlatformDependent.javaVersion() >= 21 ? 1 : 0) != 0);
            Assumptions.assumeTrue((PlatformDependent0.IS_VIRTUAL_THREAD_METHOD_HANDLE != null ? 1 : 0) != 0);
            boolean isVirtual = PlatformDependent0.IS_VIRTUAL_THREAD_METHOD_HANDLE.invokeExact(Thread.currentThread());
            Assertions.assertFalse((boolean)isVirtual);
            Method startVirtualThread = this.getStartVirtualThreadMethod();
            Thread virtualThread = (Thread)startVirtualThread.invoke(null, new Runnable(){

                @Override
                public void run() {
                }
            });
            isVirtual = PlatformDependent0.IS_VIRTUAL_THREAD_METHOD_HANDLE.invokeExact(virtualThread);
            Assertions.assertTrue((boolean)isVirtual);
        }
    }

    private Method getStartVirtualThreadMethod() throws NoSuchMethodException {
        return Thread.class.getMethod("startVirtualThread", Runnable.class);
    }

    private static class SubOfSubThread
    extends SubThread {
        private SubOfSubThread() {
        }
    }

    private static class SubThread
    extends Thread {
        private SubThread() {
        }
    }
}

