/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.SWARUtil;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SWARUtilTest {
    private final Random random = new Random();

    SWARUtilTest() {
    }

    @Test
    void containsUpperCaseLong() {
        byte[] asciiTable = SWARUtilTest.getExtendedAsciiTable();
        SWARUtilTest.shuffleArray(asciiTable, this.random);
        for (int idx = 0; idx < asciiTable.length; idx += 8) {
            long value = SWARUtilTest.getLong(asciiTable, idx);
            boolean actual = SWARUtil.containsUpperCase((long)value);
            boolean expected = false;
            for (int i = 0; i < 8; ++i) {
                expected |= Character.isUpperCase(asciiTable[idx + i]);
            }
            Assertions.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    void containsUpperCaseInt() {
        byte[] asciiTable = SWARUtilTest.getExtendedAsciiTable();
        SWARUtilTest.shuffleArray(asciiTable, this.random);
        for (int idx = 0; idx < asciiTable.length; idx += 4) {
            int value = SWARUtilTest.getInt(asciiTable, idx);
            boolean containsUpperCase = SWARUtil.containsUpperCase((int)value);
            boolean expectedContainsUpperCase = false;
            for (int i = 0; i < 4; ++i) {
                expectedContainsUpperCase |= Character.isUpperCase(asciiTable[idx + i]);
            }
            Assertions.assertEquals((Object)expectedContainsUpperCase, (Object)containsUpperCase);
        }
    }

    @Test
    void containsLowerCaseLong() {
        byte[] asciiTable = SWARUtilTest.getExtendedAsciiTable();
        SWARUtilTest.shuffleArray(asciiTable, this.random);
        for (int idx = 0; idx < asciiTable.length; idx += 8) {
            long value = SWARUtilTest.getLong(asciiTable, idx);
            boolean actual = SWARUtil.containsLowerCase((long)value);
            boolean expected = false;
            for (int i = 0; i < 8; ++i) {
                expected |= Character.isLowerCase(asciiTable[idx + i]);
            }
            Assertions.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    void containsLowerCaseInt() {
        byte[] asciiTable = SWARUtilTest.getExtendedAsciiTable();
        SWARUtilTest.shuffleArray(asciiTable, this.random);
        for (int idx = 0; idx < asciiTable.length; idx += 4) {
            int value = SWARUtilTest.getInt(asciiTable, idx);
            boolean actual = SWARUtil.containsLowerCase((int)value);
            boolean expected = false;
            for (int i = 0; i < 4; ++i) {
                expected |= Character.isLowerCase(asciiTable[idx + i]);
            }
            Assertions.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    void toUpperCaseLong() {
        byte[] asciiTable = SWARUtilTest.getExtendedAsciiTable();
        SWARUtilTest.shuffleArray(asciiTable, this.random);
        for (int idx = 0; idx < asciiTable.length; idx += 8) {
            long value = SWARUtilTest.getLong(asciiTable, idx);
            long actual = SWARUtil.toUpperCase((long)value);
            long expected = 0L;
            for (int i = 0; i < 8; ++i) {
                byte b = (byte)Character.toUpperCase(asciiTable[idx + i]);
                expected |= (long)(b & 0xFF) << 56 - 8 * i;
            }
            Assertions.assertEquals((long)expected, (long)actual);
        }
    }

    @Test
    void toUpperCaseInt() {
        byte[] asciiTable = SWARUtilTest.getExtendedAsciiTable();
        SWARUtilTest.shuffleArray(asciiTable, this.random);
        for (int idx = 0; idx < asciiTable.length; idx += 4) {
            int value = SWARUtilTest.getInt(asciiTable, idx);
            int actual = SWARUtil.toUpperCase((int)value);
            int expected = 0;
            for (int i = 0; i < 4; ++i) {
                byte b = (byte)Character.toUpperCase(asciiTable[idx + i]);
                expected |= (b & 0xFF) << 24 - 8 * i;
            }
            Assertions.assertEquals((int)expected, (int)actual);
        }
    }

    @Test
    void toLowerCaseLong() {
        byte[] asciiTable = SWARUtilTest.getExtendedAsciiTable();
        SWARUtilTest.shuffleArray(asciiTable, this.random);
        for (int idx = 0; idx < asciiTable.length; idx += 8) {
            long value = SWARUtilTest.getLong(asciiTable, idx);
            long actual = SWARUtil.toLowerCase((long)value);
            long expected = 0L;
            for (int i = 0; i < 8; ++i) {
                byte b = (byte)Character.toLowerCase(asciiTable[idx + i]);
                expected |= (long)(b & 0xFF) << 56 - 8 * i;
            }
            Assertions.assertEquals((long)expected, (long)actual);
        }
    }

    @Test
    void toLowerCaseInt() {
        byte[] asciiTable = SWARUtilTest.getExtendedAsciiTable();
        SWARUtilTest.shuffleArray(asciiTable, this.random);
        for (int idx = 0; idx < asciiTable.length; idx += 4) {
            int value = SWARUtilTest.getInt(asciiTable, idx);
            int actual = SWARUtil.toLowerCase((int)value);
            int expected = 0;
            for (int i = 0; i < 4; ++i) {
                byte b = (byte)Character.toLowerCase(asciiTable[idx + i]);
                expected |= (b & 0xFF) << 24 - 8 * i;
            }
            Assertions.assertEquals((int)expected, (int)actual);
        }
    }

    private static void shuffleArray(byte[] array, Random random) {
        for (int i = array.length - 1; i > 0; --i) {
            int index = random.nextInt(i + 1);
            byte tmp = array[index];
            array[index] = array[i];
            array[i] = tmp;
        }
    }

    private static byte[] getExtendedAsciiTable() {
        byte[] table = new byte[256];
        for (int i = 0; i < 256; ++i) {
            table[i] = (byte)i;
        }
        return table;
    }

    private static long getLong(byte[] bytes, int idx) {
        assert (idx >= 0 && bytes.length >= idx + 8);
        return (long)bytes[idx] << 56 | ((long)bytes[idx + 1] & 0xFFL) << 48 | ((long)bytes[idx + 2] & 0xFFL) << 40 | ((long)bytes[idx + 3] & 0xFFL) << 32 | ((long)bytes[idx + 4] & 0xFFL) << 24 | ((long)bytes[idx + 5] & 0xFFL) << 16 | ((long)bytes[idx + 6] & 0xFFL) << 8 | (long)bytes[idx + 7] & 0xFFL;
    }

    private static int getInt(byte[] bytes, int idx) {
        assert (idx >= 0 && bytes.length >= idx + 4);
        return bytes[idx] << 24 | (bytes[idx + 1] & 0xFF) << 16 | (bytes[idx + 2] & 0xFF) << 8 | bytes[idx + 3] & 0xFF;
    }
}

