/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.BoundedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;

public class BoundedInputStreamTest {
    @RepeatedTest(value=50)
    void testBoundEnforced() throws IOException {
        byte[] bytes = new byte[64];
        ThreadLocalRandom.current().nextBytes(bytes);
        try (BoundedInputStream reader = new BoundedInputStream((InputStream)new ByteArrayInputStream(bytes), bytes.length - 1);){
            org.junit.jupiter.api.Assertions.assertEquals((byte)bytes[0], (byte)((byte)reader.read()));
            org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> {
                int result;
                int max = bytes.length;
                do {
                    result = reader.read(new byte[max], 0, max);
                    Assertions.assertThat((int)result).isNotEqualTo(-1);
                } while ((max -= result) > 0);
            });
        }
    }

    @Test
    void testBoundEnforced256() throws IOException {
        byte[] bytes = new byte[256];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)i;
        }
        try (BoundedInputStream reader = new BoundedInputStream((InputStream)new ByteArrayInputStream(bytes), bytes.length - 1);){
            for (byte expectedByte : bytes) {
                org.junit.jupiter.api.Assertions.assertEquals((byte)expectedByte, (byte)((byte)reader.read()));
            }
            org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> ((BoundedInputStream)reader).read());
            org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> reader.read(new byte[1], 0, 1));
        }
    }

    @RepeatedTest(value=50)
    void testBigReadsPermittedIfUnderlyingStreamIsSmall() throws IOException {
        byte[] bytes = new byte[64];
        ThreadLocalRandom.current().nextBytes(bytes);
        try (BoundedInputStream reader = new BoundedInputStream((InputStream)new ByteArrayInputStream(bytes), 8192);){
            byte[] buffer = new byte[10000];
            Assertions.assertThat((int)reader.read(buffer, 0, 10000)).isEqualTo(64);
            org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])bytes, (byte[])Arrays.copyOfRange(buffer, 0, 64));
        }
    }
}

