/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.concurrent.UnorderedThreadPoolEventExecutor;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class UnorderedThreadPoolEventExecutorTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotEndlessExecute() throws Exception {
        UnorderedThreadPoolEventExecutor executor = new UnorderedThreadPoolEventExecutor(1);
        try {
            final Exchanger<Object> exchanger = new Exchanger<Object>();
            final CountDownLatch latch = new CountDownLatch(3);
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    try {
                        exchanger.exchange(null);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    latch.countDown();
                }
            };
            executor.execute(task);
            Future future = executor.submit(new Runnable(){

                @Override
                public void run() {
                    latch.countDown();
                }
            }).addListener((GenericFutureListener)new FutureListener<Object>(){

                public void operationComplete(Future<Object> future) throws Exception {
                    latch.countDown();
                }
            });
            exchanger.exchange(null);
            latch.await();
            future.syncUninterruptibly();
            for (int i = 0; i < 10000; ++i) {
                Assertions.assertTrue((boolean)executor.getQueue().isEmpty());
            }
        }
        finally {
            executor.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void scheduledAtFixedRateMustRunTaskRepeatedly() throws InterruptedException {
        UnorderedThreadPoolEventExecutor executor = new UnorderedThreadPoolEventExecutor(1);
        final CountDownLatch latch = new CountDownLatch(3);
        ScheduledFuture future = executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        }, 1L, 1L, TimeUnit.MILLISECONDS);
        try {
            latch.await();
        }
        finally {
            future.cancel(true);
            executor.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetReturnsCorrectValueOnSuccess() throws Exception {
        UnorderedThreadPoolEventExecutor executor = new UnorderedThreadPoolEventExecutor(1);
        try {
            String expected = "expected";
            Future f = executor.submit((Callable)new Callable<String>(){

                @Override
                public String call() {
                    return "expected";
                }
            });
            Assertions.assertEquals((Object)"expected", (Object)f.get());
        }
        finally {
            executor.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetReturnsCorrectValueOnFailure() throws Exception {
        UnorderedThreadPoolEventExecutor executor = new UnorderedThreadPoolEventExecutor(1);
        try {
            final RuntimeException cause = new RuntimeException();
            Future f = executor.submit((Callable)new Callable<String>(){

                @Override
                public String call() {
                    throw cause;
                }
            });
            Assertions.assertSame((Object)cause, (Object)f.await().cause());
        }
        finally {
            executor.shutdownGracefully();
        }
    }

    @Test
    void tasksRunningInUnorderedExecutorAreInEventLoop() throws Exception {
        UnorderedThreadPoolEventExecutor executor = new UnorderedThreadPoolEventExecutor(1);
        try {
            Future future = executor.submit(() -> executor.inEventLoop());
            Assertions.assertTrue((boolean)((Boolean)future.get()));
        }
        finally {
            executor.shutdownGracefully();
        }
    }
}

