/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class PromiseCombinerTest {
    @Mock
    private Promise<Void> p1;
    private GenericFutureListener<Future<Void>> l1;
    private final GenericFutureListenerConsumer l1Consumer = new GenericFutureListenerConsumer(){

        @Override
        public void accept(GenericFutureListener<Future<Void>> listener) {
            PromiseCombinerTest.this.l1 = listener;
        }
    };
    @Mock
    private Promise<Void> p2;
    private GenericFutureListener<Future<Void>> l2;
    private final GenericFutureListenerConsumer l2Consumer = new GenericFutureListenerConsumer(){

        @Override
        public void accept(GenericFutureListener<Future<Void>> listener) {
            PromiseCombinerTest.this.l2 = listener;
        }
    };
    @Mock
    private Promise<Void> p3;
    private PromiseCombiner combiner;

    @BeforeEach
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.combiner = new PromiseCombiner((EventExecutor)ImmediateEventExecutor.INSTANCE);
    }

    @Test
    public void testNullArgument() {
        try {
            this.combiner.finish(null);
            Assertions.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.combiner.finish(this.p1);
        ((Promise)Mockito.verify(this.p1)).trySuccess(null);
    }

    @Test
    public void testNullAggregatePromise() {
        this.combiner.finish(this.p1);
        ((Promise)Mockito.verify(this.p1)).trySuccess(null);
    }

    @Test
    public void testAddNullPromise() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                PromiseCombinerTest.this.combiner.add(null);
            }
        });
    }

    @Test
    public void testAddAllNullPromise() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                PromiseCombinerTest.this.combiner.addAll(null);
            }
        });
    }

    @Test
    public void testAddAfterFinish() {
        this.combiner.finish(this.p1);
        Assertions.assertThrows(IllegalStateException.class, (Executable)new Executable(){

            public void execute() {
                PromiseCombinerTest.this.combiner.add(PromiseCombinerTest.this.p2);
            }
        });
    }

    @Test
    public void testAddAllAfterFinish() {
        this.combiner.finish(this.p1);
        Assertions.assertThrows(IllegalStateException.class, (Executable)new Executable(){

            public void execute() {
                PromiseCombinerTest.this.combiner.addAll(new Promise[]{PromiseCombinerTest.this.p2});
            }
        });
    }

    @Test
    public void testFinishCalledTwiceThrows() {
        this.combiner.finish(this.p1);
        Assertions.assertThrows(IllegalStateException.class, (Executable)new Executable(){

            public void execute() {
                PromiseCombinerTest.this.combiner.finish(PromiseCombinerTest.this.p1);
            }
        });
    }

    @Test
    public void testAddAllSuccess() throws Exception {
        PromiseCombinerTest.mockSuccessPromise(this.p1, this.l1Consumer);
        PromiseCombinerTest.mockSuccessPromise(this.p2, this.l2Consumer);
        this.combiner.addAll(new Promise[]{this.p1, this.p2});
        this.combiner.finish(this.p3);
        this.l1.operationComplete(this.p1);
        PromiseCombinerTest.verifyNotCompleted(this.p3);
        this.l2.operationComplete(this.p2);
        PromiseCombinerTest.verifySuccess(this.p3);
    }

    @Test
    public void testAddSuccess() throws Exception {
        PromiseCombinerTest.mockSuccessPromise(this.p1, this.l1Consumer);
        PromiseCombinerTest.mockSuccessPromise(this.p2, this.l2Consumer);
        this.combiner.add(this.p1);
        this.l1.operationComplete(this.p1);
        this.combiner.add(this.p2);
        this.l2.operationComplete(this.p2);
        PromiseCombinerTest.verifyNotCompleted(this.p3);
        this.combiner.finish(this.p3);
        PromiseCombinerTest.verifySuccess(this.p3);
    }

    @Test
    public void testAddAllFail() throws Exception {
        RuntimeException e1 = new RuntimeException("fake exception 1");
        RuntimeException e2 = new RuntimeException("fake exception 2");
        PromiseCombinerTest.mockFailedPromise(this.p1, e1, this.l1Consumer);
        PromiseCombinerTest.mockFailedPromise(this.p2, e2, this.l2Consumer);
        this.combiner.addAll(new Promise[]{this.p1, this.p2});
        this.combiner.finish(this.p3);
        this.l1.operationComplete(this.p1);
        PromiseCombinerTest.verifyNotCompleted(this.p3);
        this.l2.operationComplete(this.p2);
        PromiseCombinerTest.verifyFail(this.p3, e1);
    }

    @Test
    public void testAddFail() throws Exception {
        RuntimeException e1 = new RuntimeException("fake exception 1");
        RuntimeException e2 = new RuntimeException("fake exception 2");
        PromiseCombinerTest.mockFailedPromise(this.p1, e1, this.l1Consumer);
        PromiseCombinerTest.mockFailedPromise(this.p2, e2, this.l2Consumer);
        this.combiner.add(this.p1);
        this.l1.operationComplete(this.p1);
        this.combiner.add(this.p2);
        this.l2.operationComplete(this.p2);
        PromiseCombinerTest.verifyNotCompleted(this.p3);
        this.combiner.finish(this.p3);
        PromiseCombinerTest.verifyFail(this.p3, e1);
    }

    @Test
    public void testEventExecutor() {
        EventExecutor executor = (EventExecutor)Mockito.mock(EventExecutor.class);
        Mockito.when((Object)executor.inEventLoop()).thenReturn((Object)false);
        this.combiner = new PromiseCombiner(executor);
        Future future = (Future)Mockito.mock(Future.class);
        try {
            this.combiner.add(future);
            Assertions.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.combiner.addAll(new Future[]{future});
            Assertions.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Promise promise = (Promise)Mockito.mock(Promise.class);
        try {
            this.combiner.finish(promise);
            Assertions.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static void verifyFail(Promise<Void> p, Throwable cause) {
        ((Promise)Mockito.verify(p)).tryFailure((Throwable)Mockito.eq((Object)cause));
    }

    private static void verifySuccess(Promise<Void> p) {
        ((Promise)Mockito.verify(p)).trySuccess(null);
    }

    private static void verifyNotCompleted(Promise<Void> p) {
        ((Promise)Mockito.verify(p, (VerificationMode)Mockito.never())).trySuccess((Object)((Void)Mockito.any(Void.class)));
        ((Promise)Mockito.verify(p, (VerificationMode)Mockito.never())).tryFailure((Throwable)Mockito.any(Throwable.class));
        ((Promise)Mockito.verify(p, (VerificationMode)Mockito.never())).setSuccess((Object)((Void)Mockito.any(Void.class)));
        ((Promise)Mockito.verify(p, (VerificationMode)Mockito.never())).setFailure((Throwable)Mockito.any(Throwable.class));
    }

    private static void mockSuccessPromise(Promise<Void> p, GenericFutureListenerConsumer consumer) {
        Mockito.when((Object)p.isDone()).thenReturn((Object)true);
        Mockito.when((Object)p.isSuccess()).thenReturn((Object)true);
        PromiseCombinerTest.mockListener(p, consumer);
    }

    private static void mockFailedPromise(Promise<Void> p, Throwable cause, GenericFutureListenerConsumer consumer) {
        Mockito.when((Object)p.isDone()).thenReturn((Object)true);
        Mockito.when((Object)p.isSuccess()).thenReturn((Object)false);
        Mockito.when((Object)p.cause()).thenReturn((Object)cause);
        PromiseCombinerTest.mockListener(p, consumer);
    }

    private static void mockListener(final Promise<Void> p, final GenericFutureListenerConsumer consumer) {
        ((Promise)Mockito.doAnswer((Answer)new Answer<Promise<Void>>(){

            public Promise<Void> answer(InvocationOnMock invocation) throws Throwable {
                consumer.accept((GenericFutureListener<Future<Void>>)((GenericFutureListener)invocation.getArgument(0)));
                return p;
            }
        }).when(p)).addListener((GenericFutureListener)Mockito.any(GenericFutureListener.class));
    }

    static interface GenericFutureListenerConsumer {
        public void accept(GenericFutureListener<Future<Void>> var1);
    }
}

