/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.ObjectCleaner;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable;

public class FastThreadLocalTest {
    @BeforeEach
    public void setUp() {
        FastThreadLocal.removeAll();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)FastThreadLocal.size());
    }

    @Test
    public void testGetAndSetReturnsOldValue() {
        FastThreadLocal<Boolean> threadLocal = new FastThreadLocal<Boolean>(){

            protected Boolean initialValue() {
                return Boolean.TRUE;
            }
        };
        org.junit.jupiter.api.Assertions.assertNull((Object)threadLocal.getAndSet((Object)Boolean.FALSE));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Boolean.FALSE, (Object)threadLocal.get());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Boolean.FALSE, (Object)threadLocal.getAndSet((Object)Boolean.TRUE));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Boolean.TRUE, (Object)threadLocal.get());
        threadLocal.remove();
    }

    @Test
    public void testGetIfExists() {
        FastThreadLocal<Boolean> threadLocal = new FastThreadLocal<Boolean>(){

            protected Boolean initialValue() {
                return Boolean.TRUE;
            }
        };
        org.junit.jupiter.api.Assertions.assertNull((Object)threadLocal.getIfExists());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)threadLocal.get()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)((Boolean)threadLocal.getIfExists()));
        FastThreadLocal.removeAll();
        org.junit.jupiter.api.Assertions.assertNull((Object)threadLocal.getIfExists());
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testRemoveAll() throws Exception {
        final AtomicBoolean removed = new AtomicBoolean();
        FastThreadLocal<Boolean> var = new FastThreadLocal<Boolean>(){

            protected void onRemoval(Boolean value) {
                removed.set(true);
            }
        };
        org.junit.jupiter.api.Assertions.assertNull((Object)var.get());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)FastThreadLocal.size());
        FastThreadLocal.removeAll();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)removed.get());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)FastThreadLocal.size());
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testRemoveAllFromFTLThread() throws Throwable {
        final AtomicReference throwable = new AtomicReference();
        FastThreadLocalThread thread = new FastThreadLocalThread(){

            public void run() {
                try {
                    FastThreadLocalTest.this.testRemoveAll();
                }
                catch (Throwable t) {
                    throwable.set(t);
                }
            }
        };
        thread.start();
        thread.join();
        Throwable t = (Throwable)throwable.get();
        if (t != null) {
            throw t;
        }
    }

    @Test
    public void testMultipleSetRemove() throws Exception {
        final FastThreadLocal threadLocal = new FastThreadLocal();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                threadLocal.set((Object)"1");
                threadLocal.remove();
                threadLocal.set((Object)"2");
                threadLocal.remove();
            }
        };
        int sizeWhenStart = ObjectCleaner.getLiveSetCount();
        Thread thread = new Thread(runnable);
        thread.start();
        thread.join();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)(ObjectCleaner.getLiveSetCount() - sizeWhenStart));
        Thread thread2 = new Thread(runnable);
        thread2.start();
        thread2.join();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)(ObjectCleaner.getLiveSetCount() - sizeWhenStart));
    }

    @Test
    public void testMultipleSetRemove_multipleThreadLocal() throws Exception {
        final FastThreadLocal threadLocal = new FastThreadLocal();
        final FastThreadLocal threadLocal2 = new FastThreadLocal();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                threadLocal.set((Object)"1");
                threadLocal.remove();
                threadLocal.set((Object)"2");
                threadLocal.remove();
                threadLocal2.set((Object)"1");
                threadLocal2.remove();
                threadLocal2.set((Object)"2");
                threadLocal2.remove();
            }
        };
        int sizeWhenStart = ObjectCleaner.getLiveSetCount();
        Thread thread = new Thread(runnable);
        thread.start();
        thread.join();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)(ObjectCleaner.getLiveSetCount() - sizeWhenStart));
        Thread thread2 = new Thread(runnable);
        thread2.start();
        thread2.join();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)(ObjectCleaner.getLiveSetCount() - sizeWhenStart));
    }

    @Test
    public void testWrappedProperties() {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)FastThreadLocalThread.currentThreadWillCleanupFastThreadLocals());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)FastThreadLocalThread.currentThreadHasFastThreadLocal());
        FastThreadLocalThread.runWithFastThreadLocal(() -> {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)FastThreadLocalThread.currentThreadWillCleanupFastThreadLocals());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)FastThreadLocalThread.currentThreadHasFastThreadLocal());
        });
    }

    @Test
    public void testWrapMany() throws ExecutionException, InterruptedException {
        int i;
        int n = 100;
        class Worker
        implements Runnable {
            final Semaphore semaphore = new Semaphore(0);
            final FutureTask<?> task = new FutureTask<Object>(this, null);

            Worker() {
            }

            @Override
            public void run() {
                org.junit.jupiter.api.Assertions.assertFalse((boolean)FastThreadLocalThread.currentThreadWillCleanupFastThreadLocals());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)FastThreadLocalThread.currentThreadHasFastThreadLocal());
                this.semaphore.acquireUninterruptibly();
                FastThreadLocalThread.runWithFastThreadLocal(() -> {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)FastThreadLocalThread.currentThreadWillCleanupFastThreadLocals());
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)FastThreadLocalThread.currentThreadHasFastThreadLocal());
                    this.semaphore.acquireUninterruptibly();
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)FastThreadLocalThread.currentThreadWillCleanupFastThreadLocals());
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)FastThreadLocalThread.currentThreadHasFastThreadLocal());
                });
                org.junit.jupiter.api.Assertions.assertFalse((boolean)FastThreadLocalThread.currentThreadWillCleanupFastThreadLocals());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)FastThreadLocalThread.currentThreadHasFastThreadLocal());
            }
        }
        ArrayList<Worker> workers = new ArrayList<Worker>();
        for (i = 0; i < n; ++i) {
            Worker worker = new Worker();
            workers.add(worker);
        }
        Collections.shuffle(workers);
        for (i = 0; i < workers.size(); ++i) {
            new Thread(((Worker)workers.get((int)i)).task, "worker-" + i).start();
        }
        for (i = 0; i < 2; ++i) {
            Collections.shuffle(workers);
            for (Worker worker : workers) {
                worker.semaphore.release();
            }
        }
        for (Worker worker : workers) {
            worker.task.get();
        }
    }

    @Test
    @Timeout(value=4000L, unit=TimeUnit.MILLISECONDS)
    public void testOnRemoveCalledForFastThreadLocalGet() throws Exception {
        FastThreadLocalTest.testOnRemoveCalled(true, false, true);
    }

    @Disabled(value="onRemoval(...) not called with non FastThreadLocal")
    @Test
    @Timeout(value=4000L, unit=TimeUnit.MILLISECONDS)
    public void testOnRemoveCalledForNonFastThreadLocalGet() throws Exception {
        FastThreadLocalTest.testOnRemoveCalled(false, false, true);
    }

    @Test
    @Timeout(value=4000L, unit=TimeUnit.MILLISECONDS)
    public void testOnRemoveCalledForFastThreadLocalSet() throws Exception {
        FastThreadLocalTest.testOnRemoveCalled(true, false, false);
    }

    @Disabled(value="onRemoval(...) not called with non FastThreadLocal")
    @Test
    @Timeout(value=4000L, unit=TimeUnit.MILLISECONDS)
    public void testOnRemoveCalledForNonFastThreadLocalSet() throws Exception {
        FastThreadLocalTest.testOnRemoveCalled(false, false, false);
    }

    @Test
    @Timeout(value=4000L, unit=TimeUnit.MILLISECONDS)
    public void testOnRemoveCalledForWrappedGet() throws Exception {
        FastThreadLocalTest.testOnRemoveCalled(false, true, true);
    }

    @Test
    @Timeout(value=4000L, unit=TimeUnit.MILLISECONDS)
    public void testOnRemoveCalledForWrappedSet() throws Exception {
        FastThreadLocalTest.testOnRemoveCalled(false, true, false);
    }

    private static void testOnRemoveCalled(boolean fastThreadLocal, boolean wrap, final boolean callGet) throws Exception {
        final TestFastThreadLocal threadLocal = new TestFastThreadLocal();
        final TestFastThreadLocal threadLocal2 = new TestFastThreadLocal();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (callGet) {
                    org.junit.jupiter.api.Assertions.assertEquals((Object)Thread.currentThread().getName(), (Object)threadLocal.get());
                    org.junit.jupiter.api.Assertions.assertEquals((Object)Thread.currentThread().getName(), (Object)threadLocal2.get());
                } else {
                    threadLocal.set(Thread.currentThread().getName());
                    threadLocal2.set(Thread.currentThread().getName());
                }
            }
        };
        if (wrap) {
            Runnable r = runnable;
            runnable = () -> FastThreadLocalThread.runWithFastThreadLocal((Runnable)r);
        }
        Object thread = fastThreadLocal ? new FastThreadLocalThread(runnable) : new Thread(runnable);
        ((Thread)thread).start();
        ((Thread)thread).join();
        String threadName = ((Thread)thread).getName();
        thread = null;
        while (threadLocal.onRemovalCalled.get() == null || threadLocal2.onRemovalCalled.get() == null) {
            System.gc();
            System.runFinalization();
            Thread.sleep(50L);
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)threadName, (Object)threadLocal.onRemovalCalled.get());
        org.junit.jupiter.api.Assertions.assertEquals((Object)threadName, (Object)threadLocal2.onRemovalCalled.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConstructionWithIndex() throws Exception {
        block9: {
            int ARRAY_LIST_CAPACITY_MAX_SIZE = 0x7FFFFFF7;
            Field nextIndexField = InternalThreadLocalMap.class.getDeclaredField("nextIndex");
            nextIndexField.setAccessible(true);
            AtomicInteger nextIndex = (AtomicInteger)nextIndexField.get(AtomicInteger.class);
            int nextIndex_before = nextIndex.get();
            AtomicReference<Throwable> throwable = new AtomicReference<Throwable>();
            try {
                while (nextIndex.get() < ARRAY_LIST_CAPACITY_MAX_SIZE) {
                    new FastThreadLocal();
                }
                org.junit.jupiter.api.Assertions.assertEquals((int)(ARRAY_LIST_CAPACITY_MAX_SIZE - 1), (int)InternalThreadLocalMap.lastVariableIndex());
                try {
                    new FastThreadLocal();
                }
                catch (Throwable t) {
                    try {
                        throwable.set(t);
                        break block9;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        org.junit.jupiter.api.Assertions.assertInstanceOf(IllegalStateException.class, throwable.get());
                        org.junit.jupiter.api.Assertions.assertEquals((int)(ARRAY_LIST_CAPACITY_MAX_SIZE - 1), (int)InternalThreadLocalMap.lastVariableIndex());
                    }
                }
                org.junit.jupiter.api.Assertions.assertInstanceOf(IllegalStateException.class, throwable.get());
                org.junit.jupiter.api.Assertions.assertEquals((int)(ARRAY_LIST_CAPACITY_MAX_SIZE - 1), (int)InternalThreadLocalMap.lastVariableIndex());
            }
            finally {
                nextIndex.set(nextIndex_before);
            }
        }
    }

    @EnabledIfEnvironmentVariable(named="CI", matches="true", disabledReason="This deliberately causes OutOfMemoryErrors, for which heap dumps are automatically generated. To avoid confusion, wasted time investigating heap dumps, and to avoid heap dumps accidentally getting committed to the Git repository, we should only enable this test when running in a CI environment. We make this check by assuming a 'CI' environment variable. This matches what Github Actions is doing for us currently.")
    @Test
    public void testInternalThreadLocalMapExpand() throws Exception {
        final AtomicReference throwable = new AtomicReference();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int expand_threshold = 0x40000000;
                try {
                    InternalThreadLocalMap.get().setIndexedVariable(expand_threshold, null);
                }
                catch (Throwable t) {
                    throwable.set(t);
                }
            }
        };
        FastThreadLocalThread fastThreadLocalThread = new FastThreadLocalThread(runnable);
        fastThreadLocalThread.start();
        fastThreadLocalThread.join();
        Assertions.assertThat((Throwable)((Throwable)throwable.get())).isNotInstanceOf(NegativeArraySizeException.class);
    }

    @Test
    public void testFastThreadLocalSize() throws Exception {
        int originSize = FastThreadLocal.size();
        org.junit.jupiter.api.Assertions.assertTrue((originSize >= 0 ? 1 : 0) != 0);
        InternalThreadLocalMap.get();
        org.junit.jupiter.api.Assertions.assertEquals((int)originSize, (int)FastThreadLocal.size());
        new FastThreadLocal();
        org.junit.jupiter.api.Assertions.assertEquals((int)originSize, (int)FastThreadLocal.size());
        FastThreadLocal fst2 = new FastThreadLocal();
        fst2.get();
        org.junit.jupiter.api.Assertions.assertEquals((int)(1 + originSize), (int)FastThreadLocal.size());
        FastThreadLocal fst3 = new FastThreadLocal();
        fst3.set(null);
        org.junit.jupiter.api.Assertions.assertEquals((int)(2 + originSize), (int)FastThreadLocal.size());
        FastThreadLocal fst4 = new FastThreadLocal();
        fst4.set((Object)Boolean.TRUE);
        org.junit.jupiter.api.Assertions.assertEquals((int)(3 + originSize), (int)FastThreadLocal.size());
        fst4.set((Object)Boolean.TRUE);
        org.junit.jupiter.api.Assertions.assertEquals((int)(3 + originSize), (int)FastThreadLocal.size());
        fst4.remove();
        org.junit.jupiter.api.Assertions.assertEquals((int)(2 + originSize), (int)FastThreadLocal.size());
        FastThreadLocal.removeAll();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)FastThreadLocal.size());
    }

    @Test
    public void testFastThreadLocalInitialValueWithUnset() throws Exception {
        final AtomicReference throwable = new AtomicReference();
        final FastThreadLocal fst = new FastThreadLocal(){

            protected Object initialValue() throws Exception {
                return InternalThreadLocalMap.UNSET;
            }
        };
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    fst.get();
                }
                catch (Throwable t) {
                    throwable.set(t);
                }
            }
        };
        FastThreadLocalThread fastThreadLocalThread = new FastThreadLocalThread(runnable);
        fastThreadLocalThread.start();
        fastThreadLocalThread.join();
        org.junit.jupiter.api.Assertions.assertInstanceOf(IllegalArgumentException.class, throwable.get());
    }

    private static final class TestFastThreadLocal
    extends FastThreadLocal<String> {
        final AtomicReference<String> onRemovalCalled = new AtomicReference();

        private TestFastThreadLocal() {
        }

        protected String initialValue() throws Exception {
            return Thread.currentThread().getName();
        }

        protected void onRemoval(String value) throws Exception {
            this.onRemovalCalled.set(value);
        }
    }
}

