/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.DefaultMockTicker;
import io.netty.util.concurrent.MockTicker;
import io.netty.util.concurrent.Ticker;
import java.util.ArrayList;
import java.util.concurrent.CompletionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

class DefaultMockTickerTest {
    DefaultMockTickerTest() {
    }

    @Test
    void newMockTickerShouldReturnDefaultMockTicker() {
        Assertions.assertTrue((boolean)(Ticker.newMockTicker() instanceof DefaultMockTicker));
    }

    @Test
    void defaultValues() {
        MockTicker ticker = Ticker.newMockTicker();
        Assertions.assertEquals((long)0L, (long)ticker.initialNanoTime());
        Assertions.assertEquals((long)0L, (long)ticker.nanoTime());
    }

    @Test
    void advanceWithoutWaiters() {
        MockTicker ticker = Ticker.newMockTicker();
        ticker.advance(42L, TimeUnit.NANOSECONDS);
        Assertions.assertEquals((long)0L, (long)ticker.initialNanoTime());
        Assertions.assertEquals((long)42L, (long)ticker.nanoTime());
        ticker.advanceMillis(42L);
        Assertions.assertEquals((long)42000042L, (long)ticker.nanoTime());
    }

    @Test
    void advanceWithNegativeAmount() {
        MockTicker ticker = Ticker.newMockTicker();
        Assertions.assertThrows(IllegalArgumentException.class, () -> ticker.advance(-1L, TimeUnit.SECONDS));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ticker.advanceMillis(-1L));
    }

    @Timeout(value=60L)
    @Test
    void advanceWithWaiters() throws Exception {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        DefaultMockTicker ticker = (DefaultMockTicker)Ticker.newMockTicker();
        int numWaiters = 4;
        ArrayList<FutureTask<Void>> futures = new ArrayList<FutureTask<Void>>();
        for (int i = 0; i < 4; ++i) {
            FutureTask<Void> task = new FutureTask<Void>(() -> {
                try {
                    ticker.sleep(1L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    throw new CompletionException(e);
                }
                return null;
            });
            Thread thread = new Thread(task);
            threads.add(thread);
            futures.add(task);
            thread.start();
        }
        try {
            for (Thread thread : threads) {
                ticker.awaitSleepingThread(thread);
            }
            int i = 0;
            while (i < 4) {
                int finalCnt = i++;
                Assertions.assertThrows(TimeoutException.class, () -> ((FutureTask)futures.get(finalCnt)).get(1L, TimeUnit.MILLISECONDS));
            }
            ticker.advance(999999L, TimeUnit.NANOSECONDS);
            for (Thread thread : threads) {
                ticker.awaitSleepingThread(thread);
            }
            i = 0;
            while (i < 4) {
                int finalCnt = i++;
                Assertions.assertThrows(TimeoutException.class, () -> ((FutureTask)futures.get(finalCnt)).get(1L, TimeUnit.MILLISECONDS));
            }
            ticker.advance(1L, TimeUnit.NANOSECONDS);
            for (i = 0; i < 4; ++i) {
                ((FutureTask)futures.get(i)).get();
            }
        }
        catch (InterruptedException ie) {
            for (Thread thread : threads) {
                String name = thread.getName();
                Thread.State state = thread.getState();
                StackTraceElement[] stackTrace = thread.getStackTrace();
                thread.interrupt();
                InterruptedException threadStackTrace = new InterruptedException(name + ": " + (Object)((Object)state));
                threadStackTrace.setStackTrace(stackTrace);
                ie.addSuppressed(threadStackTrace);
            }
            throw ie;
        }
    }

    @Test
    void sleepZero() throws InterruptedException {
        MockTicker ticker = Ticker.newMockTicker();
        ticker.sleep(0L, TimeUnit.SECONDS);
        ticker.sleepMillis(0L);
        Assertions.assertEquals((long)0L, (long)ticker.nanoTime());
    }
}

