/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.Recycler;
import io.netty.util.RecyclerTest;
import io.netty.util.RunInFastThreadLocalThreadExtension;
import io.netty.util.concurrent.FastThreadLocalThread;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@ExtendWith(value={RunInFastThreadLocalThreadExtension.class})
public class RecyclerFastThreadLocalTest
extends RecyclerTest {
    @Override
    @NotNull
    protected Thread newThread(Runnable runnable) {
        return new FastThreadLocalThread(runnable);
    }

    @Override
    @ParameterizedTest
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    @MethodSource(value={"ownerTypeAndUnguarded"})
    public void testThreadCanBeCollectedEvenIfHandledObjectIsReferenced(final RecyclerTest.OwnerType ownerType, final boolean unguarded) throws Exception {
        final AtomicBoolean collected = new AtomicBoolean();
        final AtomicReference reference = new AtomicReference();
        FastThreadLocalThread thread = new FastThreadLocalThread(new Runnable(){

            @Override
            public void run() {
                Recycler<RecyclerTest.HandledObject> recycler = RecyclerTest.newRecycler(ownerType, unguarded, 1024);
                RecyclerTest.HandledObject object = (RecyclerTest.HandledObject)recycler.get();
                reference.set(object);
                Recycler.unpinOwner(recycler);
            }
        }){

            protected void finalize() throws Throwable {
                super.finalize();
                collected.set(true);
            }
        };
        Assertions.assertFalse((boolean)collected.get());
        thread.start();
        thread.join();
        thread = null;
        while (!collected.get()) {
            System.gc();
            System.runFinalization();
            Thread.sleep(50L);
        }
        if (reference.get() != null) {
            ((RecyclerTest.HandledObject)reference.getAndSet(null)).recycle();
        }
    }
}

