/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.LeakPresenceDetector;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakTracker;
import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class LeakPresenceDetectorTest {
    private ResourceLeakDetectorFactory oldFactory;

    LeakPresenceDetectorTest() {
    }

    private void setUp(final Function<Class<?>, LeakPresenceDetector<?>> factory) {
        this.oldFactory = ResourceLeakDetectorFactory.instance();
        ResourceLeakDetectorFactory.setResourceLeakDetectorFactory((ResourceLeakDetectorFactory)new ResourceLeakDetectorFactory(){

            public <T> ResourceLeakDetector<T> newResourceLeakDetector(Class<T> resource, int samplingInterval, long maxActive) {
                return (ResourceLeakDetector)factory.apply(resource);
            }
        });
    }

    @AfterEach
    public void tearDown() {
        ResourceLeakDetectorFactory.setResourceLeakDetectorFactory((ResourceLeakDetectorFactory)this.oldFactory);
    }

    static List<Function<Class<?>, LeakPresenceDetector<?>>> factories() {
        return Collections.singletonList(LeakPresenceDetector::new);
    }

    @ParameterizedTest
    @MethodSource(value={"factories"})
    public void noExceptionInNormalOperation(Function<Class<?>, LeakPresenceDetector<?>> factory) {
        this.setUp(factory);
        Resource resource = new Resource();
        resource.close();
        resource.close();
        LeakPresenceDetector.check();
    }

    @ParameterizedTest
    @MethodSource(value={"factories"})
    public void exceptionOnUnclosed(Function<Class<?>, LeakPresenceDetector<?>> factory) {
        this.setUp(factory);
        new Resource();
        Assertions.assertThrows(IllegalStateException.class, LeakPresenceDetector::check);
    }

    @Test
    public void noExceptionInStaticInitializerGlobal() {
        this.setUp(LeakPresenceDetector::new);
        ResourceInStaticVariable1.init();
        LeakPresenceDetector.check();
    }

    private static class ResourceInStaticVariable1 {
        private static final Resource RESOURCE = (Resource)LeakPresenceDetector.staticInitializer(Resource::new);

        private ResourceInStaticVariable1() {
        }

        static void init() {
        }
    }

    private static class Resource
    implements Closeable {
        private final ResourceLeakTracker<Resource> leak = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(Resource.class).track((Object)this);

        Resource() {
        }

        @Override
        public void close() {
            this.leak.close((Object)this);
        }
    }
}

