/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.AbstractEncoderTest;
import io.netty.handler.codec.compression.Bzip2Encoder;
import java.io.InputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.junit.Assert;

public class Bzip2EncoderTest
extends AbstractEncoderTest {
    @Override
    public void initChannel() {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new Bzip2Encoder(1)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ByteBuf decompress(ByteBuf compressed, int originalLength) throws Exception {
        ByteBufInputStream is = new ByteBufInputStream(compressed, true);
        BZip2CompressorInputStream bzip2Is = null;
        byte[] decompressed = new byte[originalLength];
        try {
            int read;
            bzip2Is = new BZip2CompressorInputStream((InputStream)is);
            for (int remaining = originalLength; remaining > 0 && (read = bzip2Is.read(decompressed, originalLength - remaining, remaining)) > 0; remaining -= read) {
            }
            Assert.assertEquals((long)-1L, (long)bzip2Is.read());
        }
        finally {
            if (bzip2Is != null) {
                bzip2Is.close();
            } else {
                is.close();
            }
        }
        return Unpooled.wrappedBuffer((byte[])decompressed);
    }
}

