/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.EmptyArrays;
import java.util.Arrays;
import java.util.Random;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractIntegrationTest {
    protected static final Random rand = new Random();
    protected EmbeddedChannel encoder;
    protected EmbeddedChannel decoder;

    protected abstract EmbeddedChannel createEncoder();

    protected abstract EmbeddedChannel createDecoder();

    @Before
    public void initChannels() throws Exception {
        this.encoder = this.createEncoder();
        this.decoder = this.createDecoder();
    }

    @After
    public void closeChannels() throws Exception {
        Object msg;
        this.encoder.close();
        while ((msg = this.encoder.readOutbound()) != null) {
            ReferenceCountUtil.release((Object)msg);
        }
        this.decoder.close();
        while ((msg = this.decoder.readInbound()) != null) {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    @Test
    public void testEmpty() throws Exception {
        this.testIdentity(EmptyArrays.EMPTY_BYTES);
    }

    @Test
    public void testOneByte() throws Exception {
        byte[] data = new byte[]{65};
        this.testIdentity(data);
    }

    @Test
    public void testTwoBytes() throws Exception {
        byte[] data = new byte[]{66, 65};
        this.testIdentity(data);
    }

    @Test
    public void testRegular() throws Exception {
        byte[] data = "Netty is a NIO client server framework which enables quick and easy development of network applications such as protocol servers and clients.".getBytes(CharsetUtil.UTF_8);
        this.testIdentity(data);
    }

    @Test
    public void testLargeRandom() throws Exception {
        byte[] data = new byte[0x100000];
        rand.nextBytes(data);
        this.testIdentity(data);
    }

    @Test
    public void testPartRandom() throws Exception {
        byte[] data = new byte[10240];
        rand.nextBytes(data);
        for (int i = 0; i < 1024; ++i) {
            data[i] = 2;
        }
        this.testIdentity(data);
    }

    @Test
    public void testCompressible() throws Exception {
        byte[] data = new byte[10240];
        for (int i = 0; i < data.length; ++i) {
            data[i] = i % 4 != 0 ? (byte)0 : (byte)rand.nextInt();
        }
        this.testIdentity(data);
    }

    @Test
    public void testLongBlank() throws Exception {
        byte[] data = new byte[102400];
        this.testIdentity(data);
    }

    @Test
    public void testLongSame() throws Exception {
        byte[] data = new byte[102400];
        Arrays.fill(data, (byte)123);
        this.testIdentity(data);
    }

    @Test
    public void testSequential() throws Exception {
        byte[] data = new byte[1024];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)i;
        }
        this.testIdentity(data);
    }

    protected void testIdentity(byte[] data) {
        ByteBuf msg;
        ByteBuf in = Unpooled.wrappedBuffer((byte[])data);
        Assert.assertTrue((boolean)this.encoder.writeOutbound(new Object[]{in.retain()}));
        Assert.assertTrue((boolean)this.encoder.finish());
        CompositeByteBuf compressed = Unpooled.compositeBuffer();
        while ((msg = (ByteBuf)this.encoder.readOutbound()) != null) {
            compressed.addComponent(true, msg);
        }
        Assert.assertThat((Object)compressed, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.decoder.writeInbound(new Object[]{compressed.retain()});
        Assert.assertFalse((boolean)compressed.isReadable());
        CompositeByteBuf decompressed = Unpooled.compositeBuffer();
        while ((msg = (ByteBuf)this.decoder.readInbound()) != null) {
            decompressed.addComponent(true, msg);
        }
        Assert.assertEquals((Object)in.resetReaderIndex(), (Object)decompressed);
        compressed.release();
        decompressed.release();
        in.release();
    }
}

