/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.AbstractCompressionTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.experimental.theories.DataPoints;
import org.junit.experimental.theories.FromDataPoints;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.runner.RunWith;

@RunWith(value=Theories.class)
public abstract class AbstractEncoderTest
extends AbstractCompressionTest {
    protected EmbeddedChannel channel;

    protected abstract ByteBuf decompress(ByteBuf var1, int var2) throws Exception;

    @Before
    public abstract void initChannel();

    @After
    public void destroyChannel() {
        if (this.channel != null) {
            this.channel.finishAndReleaseAll();
            this.channel = null;
        }
    }

    @DataPoints(value={"smallData"})
    public static ByteBuf[] smallData() {
        ByteBuf heap = Unpooled.wrappedBuffer((byte[])BYTES_SMALL);
        ByteBuf direct = Unpooled.directBuffer((int)BYTES_SMALL.length);
        direct.writeBytes(BYTES_SMALL);
        return new ByteBuf[]{heap, direct};
    }

    @DataPoints(value={"largeData"})
    public static ByteBuf[] largeData() {
        ByteBuf heap = Unpooled.wrappedBuffer((byte[])BYTES_LARGE);
        ByteBuf direct = Unpooled.directBuffer((int)BYTES_LARGE.length);
        direct.writeBytes(BYTES_LARGE);
        return new ByteBuf[]{heap, direct};
    }

    @Theory
    public void testCompressionOfSmallChunkOfData(@FromDataPoints(value="smallData") ByteBuf data) throws Exception {
        this.testCompression(data);
    }

    @Theory
    public void testCompressionOfLargeChunkOfData(@FromDataPoints(value="largeData") ByteBuf data) throws Exception {
        this.testCompression(data);
    }

    @Theory
    public void testCompressionOfBatchedFlowOfData(@FromDataPoints(value="largeData") ByteBuf data) throws Exception {
        this.testCompressionOfBatchedFlow(data);
    }

    protected void testCompression(ByteBuf data) throws Exception {
        int dataLength = data.readableBytes();
        Assert.assertTrue((boolean)this.channel.writeOutbound(new Object[]{data.retain()}));
        Assert.assertTrue((boolean)this.channel.finish());
        ByteBuf decompressed = this.readDecompressed(dataLength);
        Assert.assertEquals((Object)data.resetReaderIndex(), (Object)decompressed);
        decompressed.release();
        data.release();
    }

    protected void testCompressionOfBatchedFlow(ByteBuf data) throws Exception {
        ByteBuf in;
        int dataLength = data.readableBytes();
        int written = 0;
        int length = rand.nextInt(100);
        while (written + length < dataLength) {
            in = data.retainedSlice(written, length);
            Assert.assertTrue((boolean)this.channel.writeOutbound(new Object[]{in}));
            written += length;
            length = rand.nextInt(100);
        }
        in = data.retainedSlice(written, dataLength - written);
        Assert.assertTrue((boolean)this.channel.writeOutbound(new Object[]{in}));
        Assert.assertTrue((boolean)this.channel.finish());
        ByteBuf decompressed = this.readDecompressed(dataLength);
        Assert.assertEquals((Object)data, (Object)decompressed);
        decompressed.release();
        data.release();
    }

    protected ByteBuf readDecompressed(int dataLength) throws Exception {
        ByteBuf msg;
        CompositeByteBuf compressed = Unpooled.compositeBuffer();
        while ((msg = (ByteBuf)this.channel.readOutbound()) != null) {
            compressed.addComponent(true, msg);
        }
        return this.decompress((ByteBuf)compressed, dataLength);
    }
}

