/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.handler.codec.EmptyHeaders;
import io.netty.handler.codec.Headers;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public class EmptyHeadersTest {
    private static final TestEmptyHeaders HEADERS = new TestEmptyHeaders();

    @Test(expected=UnsupportedOperationException.class)
    public void testAddStringValue() {
        HEADERS.add("name", "value");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddStringValues() {
        HEADERS.add("name", new String[]{"value1", "value2"});
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddStringValuesIterable() {
        HEADERS.add("name", Arrays.asList("value1", "value2"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddBoolean() {
        HEADERS.addBoolean("name", true);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddByte() {
        HEADERS.addByte("name", (byte)1);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddChar() {
        HEADERS.addChar("name", 'a');
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddDouble() {
        HEADERS.addDouble("name", 0.0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddFloat() {
        HEADERS.addFloat("name", 0.0f);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddInt() {
        HEADERS.addInt("name", 0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddLong() {
        HEADERS.addLong("name", 0L);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddShort() {
        HEADERS.addShort("name", (short)0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddTimeMillis() {
        HEADERS.addTimeMillis("name", 0L);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetStringValue() {
        HEADERS.set("name", "value");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetStringValues() {
        HEADERS.set("name", new String[]{"value1", "value2"});
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetStringValuesIterable() {
        HEADERS.set("name", Arrays.asList("value1", "value2"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetBoolean() {
        HEADERS.setBoolean("name", true);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetByte() {
        HEADERS.setByte("name", (byte)1);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetChar() {
        HEADERS.setChar("name", 'a');
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetDouble() {
        HEADERS.setDouble("name", 0.0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetFloat() {
        HEADERS.setFloat("name", 0.0f);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetInt() {
        HEADERS.setInt("name", 0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetLong() {
        HEADERS.setLong("name", 0L);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetShort() {
        HEADERS.setShort("name", (short)0);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetTimeMillis() {
        HEADERS.setTimeMillis("name", 0L);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetAll() {
        HEADERS.setAll((Headers)new TestEmptyHeaders());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSet() {
        HEADERS.set((Headers)new TestEmptyHeaders());
    }

    @Test
    public void testGet() {
        Assert.assertNull((Object)HEADERS.get("name1"));
    }

    @Test
    public void testGetDefault() {
        Assert.assertEquals((Object)"default", (Object)HEADERS.get("name1", "default"));
    }

    @Test
    public void testGetAndRemove() {
        Assert.assertNull((Object)HEADERS.getAndRemove("name1"));
    }

    @Test
    public void testGetAndRemoveDefault() {
        Assert.assertEquals((Object)"default", (Object)HEADERS.getAndRemove("name1", "default"));
    }

    @Test
    public void testGetAll() {
        Assert.assertEquals(Collections.emptyList(), (Object)HEADERS.getAll("name1"));
    }

    @Test
    public void testGetAllAndRemove() {
        Assert.assertEquals(Collections.emptyList(), (Object)HEADERS.getAllAndRemove("name1"));
    }

    @Test
    public void testGetBoolean() {
        Assert.assertNull((Object)HEADERS.getBoolean("name1"));
    }

    @Test
    public void testGetBooleanDefault() {
        Assert.assertTrue((boolean)HEADERS.getBoolean("name1", true));
    }

    @Test
    public void testGetBooleanAndRemove() {
        Assert.assertNull((Object)HEADERS.getBooleanAndRemove("name1"));
    }

    @Test
    public void testGetBooleanAndRemoveDefault() {
        Assert.assertTrue((boolean)HEADERS.getBooleanAndRemove("name1", true));
    }

    @Test
    public void testGetByte() {
        Assert.assertNull((Object)HEADERS.getByte("name1"));
    }

    @Test
    public void testGetByteDefault() {
        Assert.assertEquals((long)0L, (long)HEADERS.getByte("name1", (byte)0));
    }

    @Test
    public void testGetByteAndRemove() {
        Assert.assertNull((Object)HEADERS.getByteAndRemove("name1"));
    }

    @Test
    public void testGetByteAndRemoveDefault() {
        Assert.assertEquals((long)0L, (long)HEADERS.getByteAndRemove("name1", (byte)0));
    }

    @Test
    public void testGetChar() {
        Assert.assertNull((Object)HEADERS.getChar("name1"));
    }

    @Test
    public void testGetCharDefault() {
        Assert.assertEquals((long)120L, (long)HEADERS.getChar("name1", 'x'));
    }

    @Test
    public void testGetCharAndRemove() {
        Assert.assertNull((Object)HEADERS.getCharAndRemove("name1"));
    }

    @Test
    public void testGetCharAndRemoveDefault() {
        Assert.assertEquals((long)120L, (long)HEADERS.getCharAndRemove("name1", 'x'));
    }

    @Test
    public void testGetDouble() {
        Assert.assertNull((Object)HEADERS.getDouble("name1"));
    }

    @Test
    public void testGetDoubleDefault() {
        Assert.assertEquals((double)1.0, (double)HEADERS.getDouble("name1", 1.0), (double)0.0);
    }

    @Test
    public void testGetDoubleAndRemove() {
        Assert.assertNull((Object)HEADERS.getDoubleAndRemove("name1"));
    }

    @Test
    public void testGetDoubleAndRemoveDefault() {
        Assert.assertEquals((double)1.0, (double)HEADERS.getDoubleAndRemove("name1", 1.0), (double)0.0);
    }

    @Test
    public void testGetFloat() {
        Assert.assertNull((Object)HEADERS.getFloat("name1"));
    }

    @Test
    public void testGetFloatDefault() {
        Assert.assertEquals((float)1.0f, (float)HEADERS.getFloat("name1", 1.0f), (float)0.0f);
    }

    @Test
    public void testGetFloatAndRemove() {
        Assert.assertNull((Object)HEADERS.getFloatAndRemove("name1"));
    }

    @Test
    public void testGetFloatAndRemoveDefault() {
        Assert.assertEquals((float)1.0f, (float)HEADERS.getFloatAndRemove("name1", 1.0f), (float)0.0f);
    }

    @Test
    public void testGetInt() {
        Assert.assertNull((Object)HEADERS.getInt("name1"));
    }

    @Test
    public void testGetIntDefault() {
        Assert.assertEquals((long)1L, (long)HEADERS.getInt("name1", 1));
    }

    @Test
    public void testGetIntAndRemove() {
        Assert.assertNull((Object)HEADERS.getIntAndRemove("name1"));
    }

    @Test
    public void testGetIntAndRemoveDefault() {
        Assert.assertEquals((long)1L, (long)HEADERS.getIntAndRemove("name1", 1));
    }

    @Test
    public void testGetLong() {
        Assert.assertNull((Object)HEADERS.getLong("name1"));
    }

    @Test
    public void testGetLongDefault() {
        Assert.assertEquals((long)1L, (long)HEADERS.getLong("name1", 1L));
    }

    @Test
    public void testGetLongAndRemove() {
        Assert.assertNull((Object)HEADERS.getLongAndRemove("name1"));
    }

    @Test
    public void testGetLongAndRemoveDefault() {
        Assert.assertEquals((long)1L, (long)HEADERS.getLongAndRemove("name1", 1L));
    }

    @Test
    public void testGetShort() {
        Assert.assertNull((Object)HEADERS.getShort("name1"));
    }

    @Test
    public void testGetShortDefault() {
        Assert.assertEquals((long)1L, (long)HEADERS.getShort("name1", (short)1));
    }

    @Test
    public void testGetShortAndRemove() {
        Assert.assertNull((Object)HEADERS.getShortAndRemove("name1"));
    }

    @Test
    public void testGetShortAndRemoveDefault() {
        Assert.assertEquals((long)1L, (long)HEADERS.getShortAndRemove("name1", (short)1));
    }

    @Test
    public void testGetTimeMillis() {
        Assert.assertNull((Object)HEADERS.getTimeMillis("name1"));
    }

    @Test
    public void testGetTimeMillisDefault() {
        Assert.assertEquals((long)1L, (long)HEADERS.getTimeMillis("name1", 1L));
    }

    @Test
    public void testGetTimeMillisAndRemove() {
        Assert.assertNull((Object)HEADERS.getTimeMillisAndRemove("name1"));
    }

    @Test
    public void testGetTimeMillisAndRemoveDefault() {
        Assert.assertEquals((long)1L, (long)HEADERS.getTimeMillisAndRemove("name1", 1L));
    }

    @Test
    public void testContains() {
        Assert.assertFalse((boolean)HEADERS.contains("name1"));
    }

    @Test
    public void testContainsWithValue() {
        Assert.assertFalse((boolean)HEADERS.contains("name1", "value1"));
    }

    @Test
    public void testContainsBoolean() {
        Assert.assertFalse((boolean)HEADERS.containsBoolean("name1", false));
    }

    @Test
    public void testContainsByte() {
        Assert.assertFalse((boolean)HEADERS.containsByte("name1", (byte)120));
    }

    @Test
    public void testContainsChar() {
        Assert.assertFalse((boolean)HEADERS.containsChar("name1", 'x'));
    }

    @Test
    public void testContainsDouble() {
        Assert.assertFalse((boolean)HEADERS.containsDouble("name1", 1.0));
    }

    @Test
    public void testContainsFloat() {
        Assert.assertFalse((boolean)HEADERS.containsFloat("name1", 1.0f));
    }

    @Test
    public void testContainsInt() {
        Assert.assertFalse((boolean)HEADERS.containsInt("name1", 1));
    }

    @Test
    public void testContainsLong() {
        Assert.assertFalse((boolean)HEADERS.containsLong("name1", 1L));
    }

    @Test
    public void testContainsShort() {
        Assert.assertFalse((boolean)HEADERS.containsShort("name1", (short)1));
    }

    @Test
    public void testContainsTimeMillis() {
        Assert.assertFalse((boolean)HEADERS.containsTimeMillis("name1", 1L));
    }

    @Test
    public void testContainsObject() {
        Assert.assertFalse((boolean)HEADERS.containsObject("name1", ""));
    }

    @Test
    public void testIsEmpty() {
        Assert.assertTrue((boolean)HEADERS.isEmpty());
    }

    @Test
    public void testClear() {
        Assert.assertSame((Object)((Object)HEADERS), (Object)HEADERS.clear());
    }

    @Test
    public void testSize() {
        Assert.assertEquals((long)0L, (long)HEADERS.size());
    }

    @Test
    public void testValueIterator() {
        Assert.assertFalse((boolean)HEADERS.valueIterator("name1").hasNext());
    }

    private static final class TestEmptyHeaders
    extends EmptyHeaders<String, String, TestEmptyHeaders> {
        private TestEmptyHeaders() {
        }
    }
}

