/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.SnappyFrameEncoder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SnappyFrameEncoderTest {
    private EmbeddedChannel channel;

    @BeforeEach
    public void setUp() {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new SnappyFrameEncoder()});
    }

    @Test
    public void testSmallAmountOfDataIsUncompressed() throws Exception {
        ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{110, 101, 116, 116, 121});
        this.channel.writeOutbound(new Object[]{in});
        Assertions.assertTrue((boolean)this.channel.finish());
        ByteBuf expected = Unpooled.wrappedBuffer((byte[])new byte[]{-1, 6, 0, 0, 115, 78, 97, 80, 112, 89, 1, 9, 0, 0, 111, -104, 46, -71, 110, 101, 116, 116, 121});
        ByteBuf actual = (ByteBuf)this.channel.readOutbound();
        Assertions.assertEquals((Object)expected, (Object)actual);
        expected.release();
        actual.release();
    }

    @Test
    public void testLargeAmountOfDataIsCompressed() throws Exception {
        ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{110, 101, 116, 116, 121, 110, 101, 116, 116, 121, 110, 101, 116, 116, 121, 110, 101, 116, 116, 121});
        this.channel.writeOutbound(new Object[]{in});
        Assertions.assertTrue((boolean)this.channel.finish());
        ByteBuf expected = Unpooled.wrappedBuffer((byte[])new byte[]{-1, 6, 0, 0, 115, 78, 97, 80, 112, 89, 0, 14, 0, 0, 59, 54, -127, 55, 20, 16, 110, 101, 116, 116, 121, 58, 5, 0});
        ByteBuf actual = (ByteBuf)this.channel.readOutbound();
        Assertions.assertEquals((Object)expected, (Object)actual);
        expected.release();
        actual.release();
    }

    @Test
    public void testStreamStartIsOnlyWrittenOnce() throws Exception {
        ByteBuf m;
        ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{110, 101, 116, 116, 121});
        this.channel.writeOutbound(new Object[]{in.retain()});
        in.resetReaderIndex();
        this.channel.writeOutbound(new Object[]{in});
        Assertions.assertTrue((boolean)this.channel.finish());
        ByteBuf expected = Unpooled.wrappedBuffer((byte[])new byte[]{-1, 6, 0, 0, 115, 78, 97, 80, 112, 89, 1, 9, 0, 0, 111, -104, 46, -71, 110, 101, 116, 116, 121, 1, 9, 0, 0, 111, -104, 46, -71, 110, 101, 116, 116, 121});
        CompositeByteBuf actual = Unpooled.compositeBuffer();
        while ((m = (ByteBuf)this.channel.readOutbound()) != null) {
            actual.addComponent(true, m);
        }
        Assertions.assertEquals((Object)expected, (Object)actual);
        expected.release();
        actual.release();
    }

    @Test
    public void testInputBufferOverseek() throws Exception {
        ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{11, 0, 0, 0, 0, 0, 16, 65, 96, 119, -22, 79, -43, 76, -75, -93, 11, 104, 96, -99, 126, -98, 27, -36, 40, 117, -65, -3, -57, -83, -58, 7, 114, -14, 68, -122, 124, 88, 118, 54, 45, -26, 117, 13, -45, -9, 60, -73, -53, -44, 53, 68, -77, -71, 109, 43, -38, 59, 100, -12, -87, 44, -106, 123, -107, 38, 13, -117, -23, -49, 29, 21, 26, 66, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 66, 0, -104, -49, 16, -120, 22, 8, -52, -54, -102, -52, -119, -124, -92, -71, 101, -120, -52, -48, 45, -26, -24, 26, 41, -13, 36, 64, -47, 15, -124, -7, -16, 91, 96, 0, -93, -42, 101, 20, -74, 39, -124, 35, 43, -49, -21, -92, -20, -41, 79, 41, 110, -105, 42, -96, 90, -9, -100, -22, -62, 91, 2, 35, 113, 117, -71, 66, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1});
        this.channel.writeOutbound(new Object[]{in});
        Assertions.assertTrue((boolean)this.channel.finish());
        ByteBuf out = (ByteBuf)this.channel.readOutbound();
        out.release();
    }
}

