/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.compression.JdkZlibDecoder;
import io.netty.handler.codec.compression.JdkZlibEncoder;
import io.netty.handler.codec.compression.ZlibDecoder;
import io.netty.handler.codec.compression.ZlibEncoder;
import io.netty.handler.codec.compression.ZlibTest;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.PlatformDependent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Queue;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class JdkZlibTest
extends ZlibTest {
    @Override
    protected ZlibEncoder createEncoder(ZlibWrapper wrapper) {
        return new JdkZlibEncoder(wrapper);
    }

    @Override
    protected ZlibDecoder createDecoder(ZlibWrapper wrapper, int maxAllocation) {
        return new JdkZlibDecoder(wrapper, maxAllocation);
    }

    @Override
    @Test
    public void testZLIB_OR_NONE3() throws Exception {
        Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                JdkZlibTest.super.testZLIB_OR_NONE3();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcatenatedStreamsReadFirstOnly() throws IOException {
        EmbeddedChannel chDecoderGZip = new EmbeddedChannel(new ChannelHandler[]{this.createDecoder(ZlibWrapper.GZIP)});
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream("/multiple.gz"));
            Assertions.assertTrue((boolean)chDecoderGZip.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])bytes)}));
            Queue messages = chDecoderGZip.inboundMessages();
            Assertions.assertEquals((int)1, (int)messages.size());
            ByteBuf msg = (ByteBuf)messages.poll();
            Assertions.assertEquals((Object)"a", (Object)msg.toString(CharsetUtil.UTF_8));
            ReferenceCountUtil.release((Object)msg);
        }
        finally {
            Assertions.assertFalse((boolean)chDecoderGZip.finish());
            chDecoderGZip.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcatenatedStreamsReadFully() throws IOException {
        EmbeddedChannel chDecoderGZip = new EmbeddedChannel(new ChannelHandler[]{new JdkZlibDecoder(true)});
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream("/multiple.gz"));
            Assertions.assertTrue((boolean)chDecoderGZip.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])bytes)}));
            Queue messages = chDecoderGZip.inboundMessages();
            Assertions.assertEquals((int)2, (int)messages.size());
            for (String s : Arrays.asList("a", "b")) {
                ByteBuf msg = (ByteBuf)messages.poll();
                Assertions.assertEquals((Object)s, (Object)msg.toString(CharsetUtil.UTF_8));
                ReferenceCountUtil.release((Object)msg);
            }
        }
        finally {
            Assertions.assertFalse((boolean)chDecoderGZip.finish());
            chDecoderGZip.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcatenatedStreamsReadFullyWhenFragmented() throws IOException {
        EmbeddedChannel chDecoderGZip = new EmbeddedChannel(new ChannelHandler[]{new JdkZlibDecoder(true)});
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream("/multiple.gz"));
            ByteBuf buf = Unpooled.copiedBuffer((byte[])bytes);
            boolean written = false;
            while (buf.isReadable()) {
                written |= chDecoderGZip.writeInbound(new Object[]{buf.readRetainedSlice(1)});
            }
            buf.release();
            Assertions.assertTrue((boolean)written);
            Queue messages = chDecoderGZip.inboundMessages();
            Assertions.assertEquals((int)2, (int)messages.size());
            for (String s : Arrays.asList("a", "b")) {
                ByteBuf msg = (ByteBuf)messages.poll();
                Assertions.assertEquals((Object)s, (Object)msg.toString(CharsetUtil.UTF_8));
                ReferenceCountUtil.release((Object)msg);
            }
        }
        finally {
            Assertions.assertFalse((boolean)chDecoderGZip.finish());
            chDecoderGZip.close();
        }
    }

    @Test
    public void testDecodeWithHeaderFollowingFooter() throws Exception {
        byte[] bytes = new byte[1024];
        PlatformDependent.threadLocalRandom().nextBytes(bytes);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        GZIPOutputStream out = new GZIPOutputStream(bytesOut);
        out.write(bytes);
        out.close();
        byte[] compressed = bytesOut.toByteArray();
        ByteBuf buffer = Unpooled.buffer().writeBytes(compressed).writeBytes(compressed);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new JdkZlibDecoder(ZlibWrapper.GZIP, true)});
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{buffer.readRetainedSlice(compressed.length - 1)}));
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{buffer}));
        Assertions.assertTrue((boolean)channel.finish());
        ByteBuf uncompressedBuffer = Unpooled.wrappedBuffer((byte[])bytes);
        ByteBuf read = (ByteBuf)channel.readInbound();
        Assertions.assertEquals((Object)uncompressedBuffer, (Object)read);
        read.release();
        read = (ByteBuf)channel.readInbound();
        Assertions.assertEquals((Object)uncompressedBuffer, (Object)read);
        read.release();
        Assertions.assertNull((Object)channel.readInbound());
        uncompressedBuffer.release();
    }

    @Test
    public void testLargeEncode() throws Exception {
        byte[] smallArray = new byte[0x100000];
        byte[][] arrayOfArrays = new byte[128][];
        Arrays.fill((Object[])arrayOfArrays, smallArray);
        ByteBuf bigBuffer = Unpooled.wrappedBuffer((byte[][])arrayOfArrays);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new JdkZlibEncoder(ZlibWrapper.NONE)});
        channel.config().setAllocator((ByteBufAllocator)new LimitedByteBufAllocator(channel.alloc()));
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{bigBuffer}));
        Assertions.assertTrue((boolean)channel.finish());
        channel.checkException();
        Assertions.assertTrue((boolean)channel.releaseOutbound());
    }

    private static final class LimitedByteBufAllocator
    extends AbstractByteBufAllocator {
        private static final int MAX = 0x100000;
        private final ByteBufAllocator wrapped;

        LimitedByteBufAllocator(ByteBufAllocator wrapped) {
            this.wrapped = wrapped;
        }

        public boolean isDirectBufferPooled() {
            return this.wrapped.isDirectBufferPooled();
        }

        protected ByteBuf newHeapBuffer(int initialCapacity, int maxCapacity) {
            return this.wrapped.heapBuffer(initialCapacity, Math.min(maxCapacity, 0x100000));
        }

        protected ByteBuf newDirectBuffer(int initialCapacity, int maxCapacity) {
            return this.wrapped.directBuffer(initialCapacity, Math.min(maxCapacity, 0x100000));
        }
    }
}

