/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MessageToMessageDecoderTest {
    @Test
    void testReadIfNotAutoReadWhenNotSharable() {
        ReadCountHandler readCountHandler = new ReadCountHandler();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new MessageToMessageDecoder<String>(){
            private int count;

            protected void decode(ChannelHandlerContext ctx, String msg, List<Object> out) {
                if (this.count++ == 0) {
                    return;
                }
                out.add(msg);
            }
        }});
        channel.config().setAutoRead(false);
        channel.pipeline().addFirst(new ChannelHandler[]{readCountHandler});
        Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{"something"}));
        Assertions.assertEquals((int)1, (int)readCountHandler.readCount.get());
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{"something"}));
        Assertions.assertEquals((int)1, (int)readCountHandler.readCount.get());
        Assertions.assertTrue((boolean)channel.finishAndReleaseAll());
    }

    private static final class ReadCountHandler
    extends ChannelOutboundHandlerAdapter {
        final AtomicInteger readCount = new AtomicInteger();

        private ReadCountHandler() {
        }

        public void read(ChannelHandlerContext ctx) throws Exception {
            this.readCount.incrementAndGet();
            super.read(ctx);
        }
    }
}

