/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socksx.v4;

import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.socksx.v4.DefaultSocks4CommandResponse;
import io.netty.handler.codec.socksx.v4.Socks4ClientDecoder;
import io.netty.handler.codec.socksx.v4.Socks4CommandResponse;
import io.netty.handler.codec.socksx.v4.Socks4CommandStatus;
import io.netty.handler.codec.socksx.v4.Socks4CommonTestUtils;
import io.netty.handler.codec.socksx.v4.Socks4Message;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Socks4ClientDecoderTest {
    private static final Logger logger = LoggerFactory.getLogger(Socks4ClientDecoderTest.class);

    private static void test(Socks4CommandStatus cmdStatus, String dstAddr, int dstPort) {
        logger.debug("Testing cmdStatus: " + cmdStatus);
        DefaultSocks4CommandResponse msg = new DefaultSocks4CommandResponse(cmdStatus, dstAddr, dstPort);
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new Socks4ClientDecoder()});
        Socks4CommonTestUtils.writeMessageIntoEmbedder(embedder, (Socks4Message)msg);
        msg = (Socks4CommandResponse)embedder.readInbound();
        Assertions.assertEquals((Object)msg.status(), (Object)cmdStatus);
        if (dstAddr != null) {
            Assertions.assertEquals((Object)msg.dstAddr(), (Object)dstAddr);
        }
        Assertions.assertEquals((int)msg.dstPort(), (int)dstPort);
        Assertions.assertNull((Object)embedder.readInbound());
    }

    @Test
    public void testSocksCmdResponseDecoder() {
        Socks4ClientDecoderTest.test(Socks4CommandStatus.IDENTD_AUTH_FAILURE, null, 0);
        Socks4ClientDecoderTest.test(Socks4CommandStatus.IDENTD_UNREACHABLE, null, 0);
        Socks4ClientDecoderTest.test(Socks4CommandStatus.REJECTED_OR_FAILED, null, 0);
        Socks4ClientDecoderTest.test(Socks4CommandStatus.SUCCESS, null, 0);
    }
}

