/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socks;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.socks.SocksAuthRequest;
import io.netty.handler.codec.socks.SocksAuthRequestDecoder;
import io.netty.handler.codec.socks.SocksCommonTestUtils;
import io.netty.handler.codec.socks.SocksMessage;
import io.netty.handler.codec.socks.SocksSubnegotiationVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SocksAuthRequestDecoderTest {
    private static final String username = "testUserName";
    private static final String password = "testPassword";

    @Test
    public void testAuthRequestDecoder() {
        SocksAuthRequest msg = new SocksAuthRequest(username, password);
        SocksAuthRequestDecoder decoder = new SocksAuthRequestDecoder();
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{decoder});
        SocksCommonTestUtils.writeMessageIntoEmbedder(embedder, (SocksMessage)msg);
        msg = (SocksAuthRequest)embedder.readInbound();
        Assertions.assertEquals((Object)username, (Object)msg.username());
        Assertions.assertEquals((Object)password, (Object)msg.password());
        Assertions.assertNull((Object)embedder.readInbound());
    }

    @Test
    public void testAuthRequestDecoderPartialSend() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new SocksAuthRequestDecoder()});
        ByteBuf byteBuf = Unpooled.buffer((int)16);
        byteBuf.writeByte((int)SocksSubnegotiationVersion.AUTH_PASSWORD.byteValue());
        byteBuf.writeByte(username.length());
        byteBuf.writeBytes(username.getBytes());
        byteBuf.writeByte(password.length());
        ch.writeInbound(new Object[]{byteBuf});
        Assertions.assertNull((Object)ch.readInbound());
        ByteBuf byteBuf2 = Unpooled.buffer();
        byteBuf2.writeBytes(password.getBytes());
        ch.writeInbound(new Object[]{byteBuf2});
        SocksAuthRequest msg = (SocksAuthRequest)ch.readInbound();
        Assertions.assertEquals((Object)username, (Object)msg.username());
        Assertions.assertEquals((Object)password, (Object)msg.password());
        Assertions.assertFalse((boolean)ch.finishAndReleaseAll());
    }
}

