/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.spdy.SpdyFrameDecoderDelegate;
import java.util.ArrayDeque;
import java.util.Queue;

final class TestSpdyFrameDecoderDelegate
implements SpdyFrameDecoderDelegate {
    private final SpdyFrameDecoderDelegate delegate;
    private final Queue<ByteBuf> buffers = new ArrayDeque<ByteBuf>();

    TestSpdyFrameDecoderDelegate(SpdyFrameDecoderDelegate delegate) {
        this.delegate = delegate;
    }

    public void readDataFrame(int streamId, boolean last, ByteBuf data) {
        this.delegate.readDataFrame(streamId, last, data);
        this.buffers.add(data);
    }

    public void readSynStreamFrame(int streamId, int associatedToStreamId, byte priority, boolean last, boolean unidirectional) {
        this.delegate.readSynStreamFrame(streamId, associatedToStreamId, priority, last, unidirectional);
    }

    public void readSynReplyFrame(int streamId, boolean last) {
        this.delegate.readSynReplyFrame(streamId, last);
    }

    public void readRstStreamFrame(int streamId, int statusCode) {
        this.delegate.readRstStreamFrame(streamId, statusCode);
    }

    public void readSettingsFrame(boolean clearPersisted) {
        this.delegate.readSettingsFrame(clearPersisted);
    }

    public void readSetting(int id, int value, boolean persistValue, boolean persisted) {
        this.delegate.readSetting(id, value, persistValue, persisted);
    }

    public void readSettingsEnd() {
        this.delegate.readSettingsEnd();
    }

    public void readPingFrame(int id) {
        this.delegate.readPingFrame(id);
    }

    public void readGoAwayFrame(int lastGoodStreamId, int statusCode) {
        this.delegate.readGoAwayFrame(lastGoodStreamId, statusCode);
    }

    public void readHeadersFrame(int streamId, boolean last) {
        this.delegate.readHeadersFrame(streamId, last);
    }

    public void readWindowUpdateFrame(int streamId, int deltaWindowSize) {
        this.delegate.readWindowUpdateFrame(streamId, deltaWindowSize);
    }

    public void readHeaderBlock(ByteBuf headerBlock) {
        this.delegate.readHeaderBlock(headerBlock);
        this.buffers.add(headerBlock);
    }

    public void readHeaderBlockEnd() {
        this.delegate.readHeaderBlockEnd();
    }

    public void readFrameError(String message) {
        this.delegate.readFrameError(message);
    }

    public void readUnknownFrame(int frameType, byte flags, ByteBuf payload) {
        this.delegate.readUnknownFrame(frameType, flags, payload);
        this.buffers.add(payload);
    }

    void releaseAll() {
        ByteBuf buf;
        while ((buf = this.buffers.poll()) != null) {
            buf.release();
        }
        return;
    }
}

