/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.spdy.SpdyFrameDecoder;
import io.netty.handler.codec.spdy.SpdyFrameDecoderDelegate;
import io.netty.handler.codec.spdy.SpdyFrameDecoderTest;
import io.netty.handler.codec.spdy.SpdyVersion;
import io.netty.handler.codec.spdy.TestSpdyFrameDecoderDelegate;
import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class SpdyUnknownFrameDecoderTest {
    private static final Random RANDOM = new Random();
    private final SpdyFrameDecoderDelegate delegate = (SpdyFrameDecoderDelegate)Mockito.mock(SpdyFrameDecoderDelegate.class);
    private final TestSpdyFrameDecoderDelegate testDelegate = new TestSpdyFrameDecoderDelegate(this.delegate);
    private SpdyFrameDecoder decoder;

    @BeforeEach
    public void createDecoder() {
        this.decoder = new SpdyFrameDecoder(SpdyVersion.SPDY_3_1, this.testDelegate){

            protected boolean isValidUnknownFrameHeader(int streamId, int type, byte flags, int length) {
                return true;
            }
        };
    }

    @AfterEach
    public void releaseBuffers() {
        this.testDelegate.releaseAll();
    }

    @Test
    public void testDecodeUnknownFrame() throws Exception {
        short type = 200;
        byte flags = -1;
        int length = 8;
        ByteBuf buf = Unpooled.buffer((int)(8 + length));
        SpdyFrameDecoderTest.encodeControlFrameHeader(buf, type, flags, length);
        long value = RANDOM.nextLong();
        buf.writeLong(value);
        this.decoder.decode(buf);
        ((SpdyFrameDecoderDelegate)Mockito.verify((Object)this.delegate)).readUnknownFrame((int)type, flags, buf.slice(8, 8));
        Assertions.assertFalse((boolean)buf.isReadable());
    }
}

