/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.spdy.DefaultSpdyUnknownFrame;
import io.netty.handler.codec.spdy.SpdyFrameCodec;
import io.netty.handler.codec.spdy.SpdyFrameEncoder;
import io.netty.handler.codec.spdy.SpdyUnknownFrame;
import io.netty.handler.codec.spdy.SpdyVersion;
import io.netty.util.CharsetUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SpdyFrameCodecTest {
    private final SpdyFrameCodec codec = new SpdyFrameCodec(SpdyVersion.SPDY_3_1, 8192, 16384, 6, 15, 8, true, true){

        protected boolean isValidUnknownFrameHeader(int streamId, int type, byte flags, int length) {
            return true;
        }
    };
    private final EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{this.codec});

    @Test
    public void testDecodeUnknownFrame() {
        SpdyFrameEncoder encoder = new SpdyFrameEncoder(SpdyVersion.SPDY_3_1);
        ByteBuf buf = encoder.encodeUnknownFrame((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, 200, (byte)13, Unpooled.wrappedBuffer((byte[])"Hello, world!".getBytes(CharsetUtil.UTF_8)));
        this.channel.writeInbound(new Object[]{buf});
        SpdyUnknownFrame frame = (SpdyUnknownFrame)this.channel.readInbound();
        Assertions.assertNotNull((Object)frame);
        Assertions.assertEquals((int)200, (int)frame.frameType());
        Assertions.assertEquals((byte)13, (byte)frame.flags());
        ByteBuf data = frame.content();
        Assertions.assertEquals((Object)"Hello, world!", (Object)data.toString(CharsetUtil.UTF_8));
        data.release();
    }

    @Test
    public void testEncodeUnknownFrame() {
        DefaultSpdyUnknownFrame spdyUnknownFrame = new DefaultSpdyUnknownFrame(200, 13, Unpooled.wrappedBuffer((byte[])"Hello, world!".getBytes(CharsetUtil.UTF_8)));
        this.channel.writeOutbound(new Object[]{spdyUnknownFrame});
        ByteBuf buf = (ByteBuf)this.channel.readOutbound();
        Assertions.assertNotNull((Object)buf);
        this.channel.writeInbound(new Object[]{buf});
        SpdyUnknownFrame frame = (SpdyUnknownFrame)this.channel.readInbound();
        Assertions.assertNotNull((Object)frame);
        Assertions.assertEquals((int)200, (int)frame.frameType());
        Assertions.assertEquals((byte)13, (byte)frame.flags());
        ByteBuf data = frame.content();
        Assertions.assertEquals((Object)"Hello, world!", (Object)data.toString(CharsetUtil.UTF_8));
        data.release();
    }
}

