/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions.compression;

import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtension;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateDecoder;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateEncoder;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateServerExtensionHandshaker;
import java.util.Collections;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PerMessageDeflateServerExtensionHandshakerTest {
    @Test
    public void testNormalHandshake() {
        PerMessageDeflateServerExtensionHandshaker handshaker = new PerMessageDeflateServerExtensionHandshaker(0);
        WebSocketServerExtension extension = handshaker.handshakeExtension(new WebSocketExtensionData("permessage-deflate", Collections.emptyMap()));
        Assertions.assertNotNull((Object)extension);
        Assertions.assertEquals((int)4, (int)extension.rsv());
        Assertions.assertTrue((boolean)(extension.newExtensionDecoder() instanceof PerMessageDeflateDecoder));
        Assertions.assertTrue((boolean)(extension.newExtensionEncoder() instanceof PerMessageDeflateEncoder));
        WebSocketExtensionData data = extension.newReponseData();
        Assertions.assertEquals((Object)"permessage-deflate", (Object)data.name());
        Assertions.assertTrue((boolean)data.parameters().isEmpty());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("client_max_window_bits", null);
        parameters.put("client_no_context_takeover", null);
        extension = handshaker.handshakeExtension(new WebSocketExtensionData("permessage-deflate", Collections.emptyMap()));
        Assertions.assertNotNull((Object)extension);
        Assertions.assertEquals((int)4, (int)extension.rsv());
        Assertions.assertTrue((boolean)(extension.newExtensionDecoder() instanceof PerMessageDeflateDecoder));
        Assertions.assertTrue((boolean)(extension.newExtensionEncoder() instanceof PerMessageDeflateEncoder));
        data = extension.newReponseData();
        Assertions.assertEquals((Object)"permessage-deflate", (Object)data.name());
        Assertions.assertTrue((boolean)data.parameters().isEmpty());
        parameters = new HashMap();
        parameters.put("server_max_window_bits", "12");
        parameters.put("server_no_context_takeover", null);
        extension = handshaker.handshakeExtension(new WebSocketExtensionData("permessage-deflate", parameters));
        Assertions.assertNull((Object)extension);
    }

    @Test
    public void testCustomHandshake() {
        PerMessageDeflateServerExtensionHandshaker handshaker = new PerMessageDeflateServerExtensionHandshaker(6, true, 10, true, true, 0);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("client_max_window_bits", null);
        parameters.put("server_max_window_bits", "12");
        parameters.put("client_no_context_takeover", null);
        parameters.put("server_no_context_takeover", null);
        WebSocketServerExtension extension = handshaker.handshakeExtension(new WebSocketExtensionData("permessage-deflate", parameters));
        Assertions.assertNotNull((Object)extension);
        Assertions.assertEquals((int)4, (int)extension.rsv());
        Assertions.assertTrue((boolean)(extension.newExtensionDecoder() instanceof PerMessageDeflateDecoder));
        Assertions.assertTrue((boolean)(extension.newExtensionEncoder() instanceof PerMessageDeflateEncoder));
        WebSocketExtensionData data = extension.newReponseData();
        Assertions.assertEquals((Object)"permessage-deflate", (Object)data.name());
        Assertions.assertTrue((boolean)data.parameters().containsKey("client_max_window_bits"));
        Assertions.assertEquals((Object)"10", data.parameters().get("client_max_window_bits"));
        Assertions.assertTrue((boolean)data.parameters().containsKey("server_max_window_bits"));
        Assertions.assertEquals((Object)"12", data.parameters().get("server_max_window_bits"));
        Assertions.assertTrue((boolean)data.parameters().containsKey("client_max_window_bits"));
        Assertions.assertTrue((boolean)data.parameters().containsKey("server_max_window_bits"));
        parameters = new HashMap();
        parameters.put("server_max_window_bits", "12");
        parameters.put("server_no_context_takeover", null);
        extension = handshaker.handshakeExtension(new WebSocketExtensionData("permessage-deflate", parameters));
        Assertions.assertNotNull((Object)extension);
        Assertions.assertEquals((int)4, (int)extension.rsv());
        Assertions.assertTrue((boolean)(extension.newExtensionDecoder() instanceof PerMessageDeflateDecoder));
        Assertions.assertTrue((boolean)(extension.newExtensionEncoder() instanceof PerMessageDeflateEncoder));
        data = extension.newReponseData();
        Assertions.assertEquals((Object)"permessage-deflate", (Object)data.name());
        Assertions.assertEquals((int)2, (int)data.parameters().size());
        Assertions.assertTrue((boolean)data.parameters().containsKey("server_max_window_bits"));
        Assertions.assertEquals((Object)"12", data.parameters().get("server_max_window_bits"));
        Assertions.assertTrue((boolean)data.parameters().containsKey("server_no_context_takeover"));
        parameters = new HashMap();
        extension = handshaker.handshakeExtension(new WebSocketExtensionData("permessage-deflate", parameters));
        Assertions.assertNotNull((Object)extension);
        data = extension.newReponseData();
        Assertions.assertEquals((Object)"permessage-deflate", (Object)data.name());
        Assertions.assertTrue((boolean)data.parameters().isEmpty());
    }
}

