/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionFilter;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateDecoder;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateEncoder;
import io.netty.util.CharsetUtil;
import java.util.Arrays;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class PerMessageDeflateEncoderTest {
    private static final Random random = new Random();

    @Test
    public void testCompressedFrame() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateEncoder(9, 15, false)});
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.NONE, (int)0)});
        byte[] payload = new byte[300];
        random.nextBytes(payload);
        BinaryWebSocketFrame frame = new BinaryWebSocketFrame(true, 1, Unpooled.wrappedBuffer((byte[])payload));
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{frame}));
        BinaryWebSocketFrame compressedFrame = (BinaryWebSocketFrame)encoderChannel.readOutbound();
        Assertions.assertNotNull((Object)compressedFrame);
        Assertions.assertNotNull((Object)compressedFrame.content());
        Assertions.assertEquals((int)5, (int)compressedFrame.rsv());
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame.content()}));
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{DeflateDecoder.FRAME_TAIL.duplicate()}));
        ByteBuf uncompressedPayload = (ByteBuf)decoderChannel.readInbound();
        Assertions.assertEquals((int)300, (int)uncompressedPayload.readableBytes());
        byte[] finalPayload = new byte[300];
        uncompressedPayload.readBytes(finalPayload);
        Assertions.assertArrayEquals((byte[])finalPayload, (byte[])payload);
        uncompressedPayload.release();
    }

    @Test
    public void testAlreadyCompressedFrame() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateEncoder(9, 15, false)});
        byte[] payload = new byte[300];
        random.nextBytes(payload);
        BinaryWebSocketFrame frame = new BinaryWebSocketFrame(true, 5, Unpooled.wrappedBuffer((byte[])payload));
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{frame}));
        BinaryWebSocketFrame newFrame = (BinaryWebSocketFrame)encoderChannel.readOutbound();
        Assertions.assertNotNull((Object)newFrame);
        Assertions.assertNotNull((Object)newFrame.content());
        Assertions.assertEquals((int)5, (int)newFrame.rsv());
        Assertions.assertEquals((int)300, (int)newFrame.content().readableBytes());
        byte[] finalPayload = new byte[300];
        newFrame.content().readBytes(finalPayload);
        Assertions.assertArrayEquals((byte[])finalPayload, (byte[])payload);
        newFrame.release();
    }

    @Test
    public void testFragmentedFrame() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateEncoder(9, 15, false, WebSocketExtensionFilter.NEVER_SKIP)});
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.NONE, (int)0)});
        byte[] payload1 = new byte[100];
        random.nextBytes(payload1);
        byte[] payload2 = new byte[100];
        random.nextBytes(payload2);
        byte[] payload3 = new byte[100];
        random.nextBytes(payload3);
        BinaryWebSocketFrame frame1 = new BinaryWebSocketFrame(false, 1, Unpooled.wrappedBuffer((byte[])payload1));
        ContinuationWebSocketFrame frame2 = new ContinuationWebSocketFrame(false, 1, Unpooled.wrappedBuffer((byte[])payload2));
        ContinuationWebSocketFrame frame3 = new ContinuationWebSocketFrame(true, 1, Unpooled.wrappedBuffer((byte[])payload3));
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{frame1}));
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{frame2}));
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{frame3}));
        BinaryWebSocketFrame compressedFrame1 = (BinaryWebSocketFrame)encoderChannel.readOutbound();
        ContinuationWebSocketFrame compressedFrame2 = (ContinuationWebSocketFrame)encoderChannel.readOutbound();
        ContinuationWebSocketFrame compressedFrame3 = (ContinuationWebSocketFrame)encoderChannel.readOutbound();
        Assertions.assertNotNull((Object)compressedFrame1);
        Assertions.assertNotNull((Object)compressedFrame2);
        Assertions.assertNotNull((Object)compressedFrame3);
        Assertions.assertEquals((int)5, (int)compressedFrame1.rsv());
        Assertions.assertEquals((int)1, (int)compressedFrame2.rsv());
        Assertions.assertEquals((int)1, (int)compressedFrame3.rsv());
        Assertions.assertFalse((boolean)compressedFrame1.isFinalFragment());
        Assertions.assertFalse((boolean)compressedFrame2.isFinalFragment());
        Assertions.assertTrue((boolean)compressedFrame3.isFinalFragment());
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame1.content()}));
        ByteBuf uncompressedPayload1 = (ByteBuf)decoderChannel.readInbound();
        byte[] finalPayload1 = new byte[100];
        uncompressedPayload1.readBytes(finalPayload1);
        Assertions.assertArrayEquals((byte[])finalPayload1, (byte[])payload1);
        uncompressedPayload1.release();
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame2.content()}));
        ByteBuf uncompressedPayload2 = (ByteBuf)decoderChannel.readInbound();
        byte[] finalPayload2 = new byte[100];
        uncompressedPayload2.readBytes(finalPayload2);
        Assertions.assertArrayEquals((byte[])finalPayload2, (byte[])payload2);
        uncompressedPayload2.release();
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame3.content()}));
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{DeflateDecoder.FRAME_TAIL.duplicate()}));
        ByteBuf uncompressedPayload3 = (ByteBuf)decoderChannel.readInbound();
        byte[] finalPayload3 = new byte[100];
        uncompressedPayload3.readBytes(finalPayload3);
        Assertions.assertArrayEquals((byte[])finalPayload3, (byte[])payload3);
        uncompressedPayload3.release();
    }

    @Test
    public void testCompressionSkipForBinaryFrame() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateEncoder(9, 15, false, WebSocketExtensionFilter.ALWAYS_SKIP)});
        byte[] payload = new byte[300];
        random.nextBytes(payload);
        BinaryWebSocketFrame binaryFrame = new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[])payload));
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{binaryFrame.copy()}));
        WebSocketFrame outboundFrame = (WebSocketFrame)encoderChannel.readOutbound();
        Assertions.assertEquals((int)0, (int)outboundFrame.rsv());
        Assertions.assertArrayEquals((byte[])payload, (byte[])ByteBufUtil.getBytes((ByteBuf)outboundFrame.content()));
        Assertions.assertTrue((boolean)outboundFrame.release());
        Assertions.assertFalse((boolean)encoderChannel.finish());
    }

    @Test
    public void testSelectivityCompressionSkip() {
        WebSocketExtensionFilter selectivityCompressionFilter = new WebSocketExtensionFilter(){

            public boolean mustSkip(WebSocketFrame frame) {
                return (frame instanceof TextWebSocketFrame || frame instanceof BinaryWebSocketFrame) && frame.content().readableBytes() < 100;
            }
        };
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateEncoder(9, 15, false, selectivityCompressionFilter)});
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.NONE, (int)0)});
        String textPayload = "not compressed payload";
        byte[] binaryPayload = new byte[101];
        random.nextBytes(binaryPayload);
        TextWebSocketFrame textFrame = new TextWebSocketFrame(textPayload);
        BinaryWebSocketFrame binaryFrame = new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[])binaryPayload));
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{textFrame}));
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{binaryFrame}));
        WebSocketFrame outboundTextFrame = (WebSocketFrame)encoderChannel.readOutbound();
        Assertions.assertEquals((int)0, (int)outboundTextFrame.rsv());
        Assertions.assertEquals((Object)textPayload, (Object)outboundTextFrame.content().toString(CharsetUtil.UTF_8));
        Assertions.assertTrue((boolean)outboundTextFrame.release());
        WebSocketFrame outboundBinaryFrame = (WebSocketFrame)encoderChannel.readOutbound();
        Assertions.assertEquals((int)4, (int)outboundBinaryFrame.rsv());
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{outboundBinaryFrame.content().retain()}));
        ByteBuf uncompressedBinaryPayload = (ByteBuf)decoderChannel.readInbound();
        Assertions.assertArrayEquals((byte[])binaryPayload, (byte[])ByteBufUtil.getBytes((ByteBuf)uncompressedBinaryPayload));
        Assertions.assertTrue((boolean)outboundBinaryFrame.release());
        Assertions.assertTrue((boolean)uncompressedBinaryPayload.release());
        Assertions.assertFalse((boolean)encoderChannel.finish());
        Assertions.assertFalse((boolean)decoderChannel.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIllegalStateWhenCompressionInProgress() {
        WebSocketExtensionFilter selectivityCompressionFilter = new WebSocketExtensionFilter(){

            public boolean mustSkip(WebSocketFrame frame) {
                return frame.content().readableBytes() < 100;
            }
        };
        final EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateEncoder(9, 15, false, selectivityCompressionFilter)});
        byte[] firstPayload = new byte[200];
        random.nextBytes(firstPayload);
        byte[] finalPayload = new byte[90];
        random.nextBytes(finalPayload);
        BinaryWebSocketFrame firstPart = new BinaryWebSocketFrame(false, 0, Unpooled.wrappedBuffer((byte[])firstPayload));
        final ContinuationWebSocketFrame finalPart = new ContinuationWebSocketFrame(true, 0, Unpooled.wrappedBuffer((byte[])finalPayload));
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{firstPart}));
        BinaryWebSocketFrame outboundFirstPart = (BinaryWebSocketFrame)encoderChannel.readOutbound();
        Assertions.assertEquals((int)4, (int)outboundFirstPart.rsv());
        Assertions.assertFalse((boolean)Arrays.equals(firstPayload, ByteBufUtil.getBytes((ByteBuf)outboundFirstPart.content())));
        Assertions.assertTrue((boolean)outboundFirstPart.release());
        try {
            Assertions.assertThrows(EncoderException.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    encoderChannel.writeOutbound(new Object[]{finalPart});
                }
            });
        }
        finally {
            Assertions.assertTrue((boolean)finalPart.release());
            Assertions.assertFalse((boolean)encoderChannel.finishAndReleaseAll());
        }
    }

    @Test
    public void testEmptyFrameCompression() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateEncoder(9, 15, false)});
        TextWebSocketFrame emptyFrame = new TextWebSocketFrame("");
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{emptyFrame}));
        TextWebSocketFrame emptyDeflateFrame = (TextWebSocketFrame)encoderChannel.readOutbound();
        Assertions.assertEquals((int)4, (int)emptyDeflateFrame.rsv());
        Assertions.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)DeflateDecoder.EMPTY_DEFLATE_BLOCK, (ByteBuf)emptyDeflateFrame.content()));
        Assertions.assertFalse((boolean)emptyDeflateFrame.release());
        Assertions.assertFalse((boolean)encoderChannel.finish());
    }

    @Test
    public void testCodecExceptionForNotFinEmptyFrame() {
        final EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateEncoder(9, 15, false)});
        final TextWebSocketFrame emptyNotFinFrame = new TextWebSocketFrame(false, 0, "");
        try {
            Assertions.assertThrows(EncoderException.class, (Executable)new Executable(){

                public void execute() {
                    encoderChannel.writeOutbound(new Object[]{emptyNotFinFrame});
                }
            });
        }
        finally {
            Assertions.assertFalse((boolean)emptyNotFinFrame.release());
            Assertions.assertFalse((boolean)encoderChannel.finish());
        }
    }
}

