/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionFilter;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateDecoder;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerFrameDeflateEncoder;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PerFrameDeflateEncoderTest {
    private static final Random random = new Random();

    @Test
    public void testCompressedFrame() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerFrameDeflateEncoder(9, 15, false)});
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.NONE, (int)0)});
        byte[] payload = new byte[300];
        random.nextBytes(payload);
        BinaryWebSocketFrame frame = new BinaryWebSocketFrame(true, 1, Unpooled.wrappedBuffer((byte[])payload));
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{frame}));
        BinaryWebSocketFrame compressedFrame = (BinaryWebSocketFrame)encoderChannel.readOutbound();
        Assertions.assertNotNull((Object)compressedFrame);
        Assertions.assertNotNull((Object)compressedFrame.content());
        Assertions.assertEquals((int)5, (int)compressedFrame.rsv());
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame.content()}));
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{DeflateDecoder.FRAME_TAIL.duplicate()}));
        ByteBuf uncompressedPayload = (ByteBuf)decoderChannel.readInbound();
        Assertions.assertEquals((int)300, (int)uncompressedPayload.readableBytes());
        byte[] finalPayload = new byte[300];
        uncompressedPayload.readBytes(finalPayload);
        Assertions.assertArrayEquals((byte[])finalPayload, (byte[])payload);
        uncompressedPayload.release();
    }

    @Test
    public void testAlreadyCompressedFrame() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerFrameDeflateEncoder(9, 15, false)});
        byte[] payload = new byte[300];
        random.nextBytes(payload);
        BinaryWebSocketFrame frame = new BinaryWebSocketFrame(true, 5, Unpooled.wrappedBuffer((byte[])payload));
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{frame}));
        BinaryWebSocketFrame newFrame = (BinaryWebSocketFrame)encoderChannel.readOutbound();
        Assertions.assertNotNull((Object)newFrame);
        Assertions.assertNotNull((Object)newFrame.content());
        Assertions.assertEquals((int)5, (int)newFrame.rsv());
        Assertions.assertEquals((int)300, (int)newFrame.content().readableBytes());
        byte[] finalPayload = new byte[300];
        newFrame.content().readBytes(finalPayload);
        Assertions.assertArrayEquals((byte[])finalPayload, (byte[])payload);
        newFrame.release();
    }

    @Test
    public void testFramementedFrame() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerFrameDeflateEncoder(9, 15, false)});
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.NONE, (int)0)});
        byte[] payload1 = new byte[100];
        random.nextBytes(payload1);
        byte[] payload2 = new byte[100];
        random.nextBytes(payload2);
        byte[] payload3 = new byte[100];
        random.nextBytes(payload3);
        BinaryWebSocketFrame frame1 = new BinaryWebSocketFrame(false, 1, Unpooled.wrappedBuffer((byte[])payload1));
        ContinuationWebSocketFrame frame2 = new ContinuationWebSocketFrame(false, 1, Unpooled.wrappedBuffer((byte[])payload2));
        ContinuationWebSocketFrame frame3 = new ContinuationWebSocketFrame(true, 1, Unpooled.wrappedBuffer((byte[])payload3));
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{frame1}));
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{frame2}));
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{frame3}));
        BinaryWebSocketFrame compressedFrame1 = (BinaryWebSocketFrame)encoderChannel.readOutbound();
        ContinuationWebSocketFrame compressedFrame2 = (ContinuationWebSocketFrame)encoderChannel.readOutbound();
        ContinuationWebSocketFrame compressedFrame3 = (ContinuationWebSocketFrame)encoderChannel.readOutbound();
        Assertions.assertNotNull((Object)compressedFrame1);
        Assertions.assertNotNull((Object)compressedFrame2);
        Assertions.assertNotNull((Object)compressedFrame3);
        Assertions.assertEquals((int)5, (int)compressedFrame1.rsv());
        Assertions.assertEquals((int)5, (int)compressedFrame2.rsv());
        Assertions.assertEquals((int)5, (int)compressedFrame3.rsv());
        Assertions.assertFalse((boolean)compressedFrame1.isFinalFragment());
        Assertions.assertFalse((boolean)compressedFrame2.isFinalFragment());
        Assertions.assertTrue((boolean)compressedFrame3.isFinalFragment());
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame1.content()}));
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{DeflateDecoder.FRAME_TAIL.duplicate()}));
        ByteBuf uncompressedPayload1 = (ByteBuf)decoderChannel.readInbound();
        byte[] finalPayload1 = new byte[100];
        uncompressedPayload1.readBytes(finalPayload1);
        Assertions.assertArrayEquals((byte[])finalPayload1, (byte[])payload1);
        uncompressedPayload1.release();
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame2.content()}));
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{DeflateDecoder.FRAME_TAIL.duplicate()}));
        ByteBuf uncompressedPayload2 = (ByteBuf)decoderChannel.readInbound();
        byte[] finalPayload2 = new byte[100];
        uncompressedPayload2.readBytes(finalPayload2);
        Assertions.assertArrayEquals((byte[])finalPayload2, (byte[])payload2);
        uncompressedPayload2.release();
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame3.content()}));
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{DeflateDecoder.FRAME_TAIL.duplicate()}));
        ByteBuf uncompressedPayload3 = (ByteBuf)decoderChannel.readInbound();
        byte[] finalPayload3 = new byte[100];
        uncompressedPayload3.readBytes(finalPayload3);
        Assertions.assertArrayEquals((byte[])finalPayload3, (byte[])payload3);
        uncompressedPayload3.release();
    }

    @Test
    public void testCompressionSkip() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerFrameDeflateEncoder(9, 15, false, WebSocketExtensionFilter.ALWAYS_SKIP)});
        byte[] payload = new byte[300];
        random.nextBytes(payload);
        BinaryWebSocketFrame binaryFrame = new BinaryWebSocketFrame(true, 0, Unpooled.wrappedBuffer((byte[])payload));
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{binaryFrame.copy()}));
        BinaryWebSocketFrame outboundFrame = (BinaryWebSocketFrame)encoderChannel.readOutbound();
        Assertions.assertNotNull((Object)outboundFrame);
        Assertions.assertNotNull((Object)outboundFrame.content());
        Assertions.assertArrayEquals((byte[])payload, (byte[])ByteBufUtil.getBytes((ByteBuf)outboundFrame.content()));
        Assertions.assertEquals((int)0, (int)outboundFrame.rsv());
        Assertions.assertTrue((boolean)outboundFrame.release());
        Assertions.assertFalse((boolean)encoderChannel.finish());
    }
}

