/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionFilter;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerFrameDeflateDecoder;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PerFrameDeflateDecoderTest {
    private static final Random random = new Random();

    @Test
    public void testCompressedFrame() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.NONE, (int)9, (int)15, (int)8)});
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerFrameDeflateDecoder(false, 0)});
        byte[] payload = new byte[300];
        random.nextBytes(payload);
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])payload)}));
        ByteBuf compressedPayload = (ByteBuf)encoderChannel.readOutbound();
        BinaryWebSocketFrame compressedFrame = new BinaryWebSocketFrame(true, 5, compressedPayload.slice(0, compressedPayload.readableBytes() - 4));
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame}));
        BinaryWebSocketFrame uncompressedFrame = (BinaryWebSocketFrame)decoderChannel.readInbound();
        Assertions.assertNotNull((Object)uncompressedFrame);
        Assertions.assertNotNull((Object)uncompressedFrame.content());
        Assertions.assertEquals((int)1, (int)uncompressedFrame.rsv());
        Assertions.assertEquals((int)300, (int)uncompressedFrame.content().readableBytes());
        byte[] finalPayload = new byte[300];
        uncompressedFrame.content().readBytes(finalPayload);
        Assertions.assertArrayEquals((byte[])finalPayload, (byte[])payload);
        uncompressedFrame.release();
    }

    @Test
    public void testNormalFrame() {
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerFrameDeflateDecoder(false, 0)});
        byte[] payload = new byte[300];
        random.nextBytes(payload);
        BinaryWebSocketFrame frame = new BinaryWebSocketFrame(true, 1, Unpooled.wrappedBuffer((byte[])payload));
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{frame}));
        BinaryWebSocketFrame newFrame = (BinaryWebSocketFrame)decoderChannel.readInbound();
        Assertions.assertNotNull((Object)newFrame);
        Assertions.assertNotNull((Object)newFrame.content());
        Assertions.assertEquals((int)1, (int)newFrame.rsv());
        Assertions.assertEquals((int)300, (int)newFrame.content().readableBytes());
        byte[] finalPayload = new byte[300];
        newFrame.content().readBytes(finalPayload);
        Assertions.assertArrayEquals((byte[])finalPayload, (byte[])payload);
        newFrame.release();
    }

    @Test
    public void testCompressedEmptyFrame() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.NONE, (int)9, (int)15, (int)8)});
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerFrameDeflateDecoder(false, 0)});
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{Unpooled.EMPTY_BUFFER}));
        ByteBuf compressedPayload = (ByteBuf)encoderChannel.readOutbound();
        BinaryWebSocketFrame compressedFrame = new BinaryWebSocketFrame(true, 5, compressedPayload);
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame}));
        BinaryWebSocketFrame uncompressedFrame = (BinaryWebSocketFrame)decoderChannel.readInbound();
        Assertions.assertNotNull((Object)uncompressedFrame);
        Assertions.assertNotNull((Object)uncompressedFrame.content());
        Assertions.assertEquals((int)1, (int)uncompressedFrame.rsv());
        Assertions.assertEquals((int)0, (int)uncompressedFrame.content().readableBytes());
        uncompressedFrame.release();
    }

    @Test
    public void testDecompressionSkip() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.NONE, (int)9, (int)15, (int)8)});
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerFrameDeflateDecoder(false, WebSocketExtensionFilter.ALWAYS_SKIP, 0)});
        byte[] payload = new byte[300];
        random.nextBytes(payload);
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])payload)}));
        ByteBuf compressedPayload = (ByteBuf)encoderChannel.readOutbound();
        BinaryWebSocketFrame compressedBinaryFrame = new BinaryWebSocketFrame(true, 5, compressedPayload);
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedBinaryFrame}));
        BinaryWebSocketFrame inboundBinaryFrame = (BinaryWebSocketFrame)decoderChannel.readInbound();
        Assertions.assertNotNull((Object)inboundBinaryFrame);
        Assertions.assertNotNull((Object)inboundBinaryFrame.content());
        Assertions.assertEquals((Object)compressedPayload, (Object)inboundBinaryFrame.content());
        Assertions.assertEquals((int)5, (int)inboundBinaryFrame.rsv());
        Assertions.assertTrue((boolean)inboundBinaryFrame.release());
        Assertions.assertTrue((boolean)encoderChannel.finishAndReleaseAll());
        Assertions.assertFalse((boolean)decoderChannel.finish());
    }
}

